/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.network.handlers;

import betterquesting.api.events.DatabaseEvent;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuestLine;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.utils.BQThreadedIO;
import betterquesting.core.BetterQuesting;
import betterquesting.network.PacketSender;
import betterquesting.network.PacketTypeRegistry;
import betterquesting.questing.QuestLineDatabase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetChapterSync {
    private static final ResourceLocation ID_NAME = new ResourceLocation("betterquesting:chapter_sync");

    public static void registerHandler() {
        PacketTypeRegistry.INSTANCE.registerServerHandler(ID_NAME, NetChapterSync::onServer);
        if (BetterQuesting.proxy.isClient()) {
            PacketTypeRegistry.INSTANCE.registerClientHandler(ID_NAME, NetChapterSync::onClient);
        }
    }

    public static void sendSync(@Nullable EntityPlayerMP player, @Nullable int[] chapterIDs) {
        if (chapterIDs != null && chapterIDs.length <= 0) {
            return;
        }
        BQThreadedIO.INSTANCE.enqueue(() -> {
            NBTTagList data = new NBTTagList();
            List chapterSubset = chapterIDs == null ? QuestLineDatabase.INSTANCE.getEntries() : QuestLineDatabase.INSTANCE.bulkLookup(chapterIDs);
            for (DBEntry chapter : chapterSubset) {
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_74768_a("chapterID", chapter.getID());
                entry.func_74782_a("config", (NBTBase)((IQuestLine)chapter.getValue()).writeToNBT(new NBTTagCompound(), null));
                data.func_74742_a((NBTBase)entry);
            }
            List<DBEntry<IQuestLine>> allSort = QuestLineDatabase.INSTANCE.getSortedEntries();
            int[] aryOrder = new int[allSort.size()];
            for (int i = 0; i < aryOrder.length; ++i) {
                aryOrder[i] = allSort.get(i).getID();
            }
            NBTTagCompound payload = new NBTTagCompound();
            payload.func_74757_a("merge", chapterIDs != null);
            payload.func_74782_a("data", (NBTBase)data);
            payload.func_74783_a("order", aryOrder);
            if (player == null) {
                PacketSender.INSTANCE.sendToAll(new QuestingPacket(ID_NAME, payload));
            } else {
                PacketSender.INSTANCE.sendToPlayers(new QuestingPacket(ID_NAME, payload), player);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestSync(@Nullable int[] chapterIDs) {
        NBTTagCompound payload = new NBTTagCompound();
        if (chapterIDs != null) {
            payload.func_74783_a("requestIDs", chapterIDs);
        }
        PacketSender.INSTANCE.sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple<NBTTagCompound, EntityPlayerMP> message) {
        NBTTagCompound payload = (NBTTagCompound)message.func_76341_a();
        int[] reqIDs = !payload.func_74764_b("requestIDs") ? null : payload.func_74759_k("requestIDs");
        NetChapterSync.sendSync((EntityPlayerMP)message.func_76340_b(), reqIDs);
    }

    @SideOnly(value=Side.CLIENT)
    private static void onClient(NBTTagCompound message) {
        NBTTagList data = message.func_150295_c("data", 10);
        if (!message.func_74767_n("merge")) {
            QuestLineDatabase.INSTANCE.reset();
        }
        for (int i = 0; i < data.func_74745_c(); ++i) {
            NBTTagCompound tag = data.func_150305_b(i);
            if (!tag.func_150297_b("chapterID", 99)) continue;
            int chapterID = tag.func_74762_e("chapterID");
            IQuestLine chapter = (IQuestLine)QuestLineDatabase.INSTANCE.getValue(chapterID);
            if (chapter == null) {
                chapter = QuestLineDatabase.INSTANCE.createNew(chapterID);
            }
            chapter.readFromNBT(tag.func_74775_l("config"), false);
        }
        int[] aryOrder = message.func_74759_k("order");
        for (int i = 0; i < aryOrder.length; ++i) {
            QuestLineDatabase.INSTANCE.setOrderIndex(aryOrder[i], i);
        }
        MinecraftForge.EVENT_BUS.post((Event)new DatabaseEvent.Update(DatabaseEvent.DBType.CHAPTER));
    }
}

