/*
 * Decompiled with CFR 0.152.
 */
package cscot.basicnetherores.world.gen;

import com.google.common.base.Predicate;
import cscot.basicnetherores.init.BlockOreInit;
import cscot.basicnetherores.util.handler.ConfigHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCustomOres
implements IWorldGenerator {
    private WorldGenerator ore_netheremerald = new WorldGenMinable(BlockOreInit.ORE_NETHEREMERALD.func_176223_P(), ConfigHandler.emeraldVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator ore_netherdiamond = new WorldGenMinable(BlockOreInit.ORE_NETHERDIAMOND.func_176223_P(), ConfigHandler.diamondVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator ore_netherredstone = new WorldGenMinable(BlockOreInit.ORE_NETHERREDSTONE.func_176223_P(), ConfigHandler.redstoneVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator ore_netherlapis = new WorldGenMinable(BlockOreInit.ORE_NETHERLAPIS.func_176223_P(), ConfigHandler.lapisVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator ore_nethercoal = new WorldGenMinable(BlockOreInit.ORE_NETHERCOAL.func_176223_P(), ConfigHandler.coalVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator ore_nethergold = new WorldGenMinable(BlockOreInit.ORE_NETHERGOLD.func_176223_P(), ConfigHandler.goldVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator ore_netheriron = new WorldGenMinable(BlockOreInit.ORE_NETHERIRON.func_176223_P(), ConfigHandler.ironVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator ore_nethercopper = new WorldGenMinable(BlockOreInit.ORE_NETHERCOPPER.func_176223_P(), ConfigHandler.copperVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    private WorldGenerator ore_nethertin = new WorldGenMinable(BlockOreInit.ORE_NETHERTIN.func_176223_P(), ConfigHandler.tinVeinSize, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.runGenerator(this.ore_netheremerald, world, random, chunkX, chunkZ, ConfigHandler.emeraldChance, ConfigHandler.emeraldMinHeight, ConfigHandler.emeraldMaxHeight);
                this.runGenerator(this.ore_netherdiamond, world, random, chunkX, chunkZ, ConfigHandler.diamondChance, ConfigHandler.diamondMinHeight, ConfigHandler.diamondMaxHeight);
                this.runGenerator(this.ore_netherredstone, world, random, chunkX, chunkZ, ConfigHandler.redstoneChance, ConfigHandler.redstoneMinHeight, ConfigHandler.redstoneMaxHeight);
                this.runGenerator(this.ore_netherlapis, world, random, chunkX, chunkZ, ConfigHandler.lapisChance, ConfigHandler.lapisMinHeight, ConfigHandler.lapisMaxHeight);
                this.runGenerator(this.ore_nethercoal, world, random, chunkX, chunkZ, ConfigHandler.coalChance, ConfigHandler.coalMinHeight, ConfigHandler.coalMaxHeight);
                this.runGenerator(this.ore_nethergold, world, random, chunkX, chunkZ, ConfigHandler.goldChance, ConfigHandler.goldMinHeight, ConfigHandler.goldMaxHeight);
                this.runGenerator(this.ore_netheriron, world, random, chunkX, chunkZ, ConfigHandler.ironChance, ConfigHandler.ironMinHeight, ConfigHandler.ironMaxHeight);
                this.runGenerator(this.ore_nethercopper, world, random, chunkX, chunkZ, ConfigHandler.copperChance, ConfigHandler.copperMinHeight, ConfigHandler.copperMaxHeight);
                this.runGenerator(this.ore_nethertin, world, random, chunkX, chunkZ, ConfigHandler.tinChance, ConfigHandler.tinMinHeight, ConfigHandler.tinMaxHeight);
            }
        }
    }

    private void runGenerator(WorldGenerator gen, World world, Random rand, int chunkX, int chunkZ, int chance, int minHeight, int maxHeight) {
        if (minHeight > maxHeight || minHeight < 0 || maxHeight > 256) {
            throw new IllegalArgumentException("Ore Generated below or above the min and max height");
        }
        int heightDiff = maxHeight - minHeight + 1;
        for (int i = 0; i < chance; ++i) {
            int x = chunkX * 16 + rand.nextInt(16);
            int y = minHeight + rand.nextInt(heightDiff);
            int z = chunkZ * 16 + rand.nextInt(16);
            gen.func_180709_b(world, rand, new BlockPos(x, y, z));
        }
    }
}

