/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.lib.util.script;

import com.bloodnbonesgaming.lib.BNBGamingLib;
import com.bloodnbonesgaming.lib.util.FileHelper;
import com.bloodnbonesgaming.lib.util.script.ArgType;
import com.bloodnbonesgaming.lib.util.script.ScriptArgs;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class ScriptDocumentationHandler {
    private static Set<ASMDataTable.ASMData> scriptDocs;

    public static void setScriptDocs(ASMDataTable asmTable) {
        scriptDocs = Sets.newHashSet((Iterable)asmTable.getAll(ScriptClassDocumentation.class.getCanonicalName()));
    }

    public static void copyDocumentationFolder(Class<?> classInJar, String destination) {
        if (BNBGamingLib.proxy.client()) {
            FileHelper.copyDirectoryFromJar(classInJar, "/documentation/", destination);
        }
    }

    public static void printAnnotatedDocumentation(String modDirectory) {
        if (BNBGamingLib.proxy.client()) {
            for (ASMDataTable.ASMData data : scriptDocs) {
                try {
                    Method[] methods;
                    Constructor<?>[] constructors;
                    Class<?> asmClass = Class.forName(data.getClassName());
                    if (!asmClass.getName().startsWith(modDirectory)) continue;
                    ScriptClassDocumentation classAnn = asmClass.getAnnotation(ScriptClassDocumentation.class);
                    String printString = "";
                    String classExplaination = classAnn.classExplaination();
                    if (!classExplaination.isEmpty()) {
                        printString = printString.concat(ScriptDocumentationHandler.lineWrap(classExplaination) + System.lineSeparator());
                        printString = printString.concat(System.lineSeparator());
                        printString = printString.concat(System.lineSeparator());
                        printString = printString.concat(System.lineSeparator());
                    }
                    for (Constructor<?> constructor : constructors = asmClass.getConstructors()) {
                        String args;
                        if (!constructor.isAnnotationPresent(ScriptMethodDocumentation.class)) continue;
                        ScriptMethodDocumentation anno = constructor.getDeclaredAnnotation(ScriptMethodDocumentation.class);
                        String usage = anno.usage();
                        String notes = anno.notes();
                        String defaultValues = anno.defaultValues();
                        if (constructor.isAnnotationPresent(ScriptArgs.class)) {
                            ScriptArgs argsAnno = constructor.getDeclaredAnnotation(ScriptArgs.class);
                            ArgType[] argTypes = argsAnno.args();
                            String temp = "";
                            for (int i = 0; i < argTypes.length; ++i) {
                                if (i > 0) {
                                    temp = temp.concat(", ");
                                }
                                temp = temp.concat(argTypes[i].toString());
                            }
                            args = temp;
                        } else {
                            args = anno.args();
                        }
                        String methodString = "Constructor:" + System.lineSeparator();
                        if (args != null && !args.isEmpty()) {
                            methodString = methodString.concat("    Arguments:" + System.lineSeparator());
                            methodString = methodString.concat("        " + args + System.lineSeparator());
                        }
                        if (usage != null && !usage.isEmpty()) {
                            methodString = methodString.concat("    Argument Usage:" + System.lineSeparator());
                            methodString = methodString.concat("        " + usage + System.lineSeparator());
                        }
                        if (defaultValues != null && !defaultValues.isEmpty()) {
                            methodString = methodString.concat("    Default Values:" + System.lineSeparator());
                            methodString = methodString.concat("        " + defaultValues + System.lineSeparator());
                        }
                        if (notes != null && !notes.isEmpty()) {
                            methodString = methodString.concat("    Notes:" + System.lineSeparator());
                            methodString = methodString.concat("        " + notes + System.lineSeparator());
                        }
                        methodString = methodString.concat(System.lineSeparator());
                        printString = printString.concat(methodString);
                    }
                    for (Method method : methods = asmClass.getMethods()) {
                        String args;
                        if (!method.isAnnotationPresent(ScriptMethodDocumentation.class)) continue;
                        ScriptMethodDocumentation anno = method.getAnnotation(ScriptMethodDocumentation.class);
                        String usage = anno.usage();
                        String notes = anno.notes();
                        String defaultValues = anno.defaultValues();
                        if (method.isAnnotationPresent(ScriptArgs.class)) {
                            ScriptArgs argsAnno = method.getAnnotation(ScriptArgs.class);
                            ArgType[] argTypes = argsAnno.args();
                            String temp = "";
                            for (int i = 0; i < argTypes.length; ++i) {
                                if (i > 0) {
                                    temp = temp.concat(", ");
                                }
                                temp = temp.concat(argTypes[i].toString());
                            }
                            args = temp;
                        } else {
                            args = anno.args();
                        }
                        String methodString = method.getName() + ":" + System.lineSeparator();
                        if (args != null && !args.isEmpty()) {
                            methodString = methodString.concat("    Arguments:" + System.lineSeparator());
                            methodString = methodString.concat("        " + args + System.lineSeparator());
                        }
                        if (usage != null && !usage.isEmpty()) {
                            methodString = methodString.concat("    Usage:" + System.lineSeparator());
                            methodString = methodString.concat("        " + usage + System.lineSeparator());
                        }
                        if (defaultValues != null && !defaultValues.isEmpty()) {
                            methodString = methodString.concat("    Default Values:" + System.lineSeparator());
                            methodString = methodString.concat("        " + defaultValues + System.lineSeparator());
                        }
                        if (notes != null && !notes.isEmpty()) {
                            methodString = methodString.concat("    Notes:" + System.lineSeparator());
                            methodString = methodString.concat("        " + notes + System.lineSeparator());
                        }
                        methodString = methodString.concat(System.lineSeparator());
                        printString = printString.concat(methodString);
                    }
                    if (printString.isEmpty()) continue;
                    FileHelper.writeText(classAnn.documentationFile() + ".txt", printString);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String lineWrap(String input) {
        StringBuilder builder = new StringBuilder(input);
        int nextWrap = 80;
        while (builder.length() > nextWrap) {
            int index = builder.indexOf(" ", nextWrap);
            if (index == -1) {
                nextWrap = builder.length();
                continue;
            }
            nextWrap = index + System.lineSeparator().length() + 81;
            builder.insert(index + 1, System.lineSeparator());
        }
        return builder.toString();
    }
}

