/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.module.entityrenderer;

import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMDebugHelper;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ObfNameHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;

public class ModuleEntityRenderer
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        String methodDesc;
        String methodName;
        ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
        MethodNode method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.HURT_CAMERA_EFFECT.getName(), methodDesc = ObfNameHelper.Methods.HURT_CAMERA_EFFECT.getDescriptor());
        if (method != null) {
            ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
            if (this.hurtCameraEffectHookAndReturn(method, transformedName)) {
                ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                return ASMHelper.writeClassToBytes(classNode, 3);
            }
        } else {
            ASMDebugHelper.logNotFound(methodName, transformedName);
        }
        return basicClass;
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{ObfNameHelper.Classes.ENTITY_RENDERER.getName()};
    }

    @Override
    public String getModuleName() {
        return "hurtCameraEffectEvent";
    }

    @Override
    public void registerAdditions(ASMAdditionRegistry arg0) {
    }

    private boolean hurtCameraEffectHookAndReturn(MethodNode method, String transformedName) {
        AbstractInsnNode target = ASMHelper.findFirstInstruction(method);
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name, transformedName);
            return false;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)ObfNameHelper.Methods.ON_HURT_CAMERA_EFFECT_EVENT.toInsnNode(184));
        toInject.add((AbstractInsnNode)new InsnNode(177));
        method.instructions.insertBefore(target, toInject);
        return true;
    }
}

