/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.module;

import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMDebugHelper;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ObfNameHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;

public class ModuleDamageSourceClass
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{ObfNameHelper.Classes.DAMAGESOURCE.getName()};
    }

    @Override
    public String getModuleName() {
        return "buildDamageSourceList";
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        String methodDesc;
        String methodName;
        ClassNode classNode = ASMHelper.readClassFromBytes(bytes);
        MethodNode method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.DAMAGESOURCE_INIT.getName(), methodDesc = ObfNameHelper.Methods.DAMAGESOURCE_INIT.getDescriptor());
        if (method != null) {
            ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
            if (this.injectListCall(method, transformedName)) {
                ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                return ASMHelper.writeClassToBytes(classNode);
            }
        } else {
            ASMDebugHelper.logNotFound(methodName, transformedName);
        }
        return bytes;
    }

    private boolean injectListCall(MethodNode method, String transformedName) {
        AbstractInsnNode target = ASMHelper.findLastInstructionWithOpcode(method, 177);
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name, transformedName);
            return false;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)ObfNameHelper.Methods.ONINITDAMAGESOURCE.toInsnNode(184));
        method.instructions.insertBefore(target, toInject);
        return true;
    }

    @Override
    public void registerAdditions(ASMAdditionRegistry arg0) {
    }
}

