/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration.crafttweaker;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.api.recipe.RecipeHandlers;
import com.teammetallurgy.atum.api.recipe.spinningwheel.SpinningWheelRecipe;
import com.teammetallurgy.atum.init.AtumItems;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.atum.SpinningWheel")
public class CTSpinningWheel {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output, int rotations) {
        CraftTweakerAPI.apply((IAction)new Add(CraftTweakerMC.getItemStack((IItemStack)input), CraftTweakerMC.getItemStack((IItemStack)output), rotations));
    }

    @ZenMethod
    public static void addInput(IItemStack input, int rotations) {
        CraftTweakerAPI.apply((IAction)new Add(CraftTweakerMC.getItemStack((IItemStack)input), new ItemStack(AtumItems.LINEN_THREAD), rotations));
    }

    @ZenMethod
    public static void removeRecipe(String id) {
        CraftTweakerAPI.apply((IAction)new Remove(id));
    }

    private static class Remove
    implements IAction {
        private String id;

        Remove(String id) {
            this.id = id;
        }

        public void apply() {
            ResourceLocation location = new ResourceLocation(this.id);
            if (!RecipeHandlers.spinningWheelRecipes.containsKey(location)) {
                Atum.LOG.error("No Spinning Wheel recipe exists called: " + this.id);
            } else {
                RecipeHandlers.spinningWheelRecipes.remove(location);
            }
        }

        public String describe() {
            return "Removed Spinning Wheel recipe: " + this.id;
        }
    }

    private static class Add
    implements IAction {
        private ItemStack input;
        private ItemStack output;
        private int rotations;

        Add(@Nonnull ItemStack input, @Nonnull ItemStack output, int rotations) {
            this.input = input;
            this.output = output;
            this.rotations = rotations;
        }

        public void apply() {
            ResourceLocation registryName = new ResourceLocation("crafttweaker", Objects.requireNonNull(this.input.func_77973_b().getRegistryName()).func_110623_a());
            RecipeHandlers.spinningWheelRecipes.register(new SpinningWheelRecipe(this.input, this.output, this.rotations).setRegistryName(registryName));
        }

        public String describe() {
            return "Added new Spinning Wheel recipe. Input: " + this.input.func_82833_r() + " Output: " + this.output.func_82833_r();
        }
    }
}

