/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.projectile;

import com.teammetallurgy.atum.entity.animal.EntityCamel;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCamelSpit
extends EntityLlamaSpit {
    private EntityCamel owner;
    private NBTTagCompound ownerNbt;

    public EntityCamelSpit(World world) {
        super(world);
    }

    public EntityCamelSpit(World world, EntityCamel camel) {
        super(world);
        this.owner = camel;
        this.func_70107_b(camel.field_70165_t - (double)(camel.field_70130_N + 1.0f) * 0.5 * (double)MathHelper.func_76126_a((float)(camel.field_70761_aq * ((float)Math.PI / 180))), camel.field_70163_u + (double)camel.func_70047_e() - (double)0.1f, camel.field_70161_v + (double)(camel.field_70130_N + 1.0f) * 0.5 * (double)MathHelper.func_76134_b((float)(camel.field_70761_aq * ((float)Math.PI / 180))));
        this.func_70105_a(0.25f, 0.25f);
    }

    @SideOnly(value=Side.CLIENT)
    public EntityCamelSpit(World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_190536_a(RayTraceResult rayTrace) {
        if (rayTrace.field_72308_g != null && this.owner != null) {
            rayTrace.field_72308_g.func_70097_a(DamageSource.func_188403_a((Entity)this, (EntityLivingBase)this.owner).func_76349_b(), 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        Entity entity;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.ownerNbt != null) {
            this.restoreOwnerFromSave();
        }
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_72933_a(vec3d, vec3d1);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d1 = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        if ((entity = this.getHitEntity(vec3d, vec3d1)) != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
            this.func_190536_a(raytraceresult);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (!this.field_70170_p.func_72875_a(this.func_174813_aQ(), Material.field_151579_a)) {
            this.func_70106_y();
        } else if (this.func_70090_H()) {
            this.func_70106_y();
        } else {
            this.field_70159_w *= (double)0.99f;
            this.field_70181_x *= (double)0.99f;
            this.field_70179_y *= (double)0.99f;
            if (!this.func_189652_ae()) {
                this.field_70181_x -= (double)0.06f;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    @Nullable
    private Entity getHitEntity(Vec3d pos, Vec3d motionPos) {
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double distance = 0.0;
        for (Entity hitEntity : list) {
            double squareDistanceTo;
            AxisAlignedBB box;
            RayTraceResult rayTrace;
            if (hitEntity == this.owner || (rayTrace = (box = hitEntity.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(pos, motionPos)) == null || !((squareDistanceTo = pos.func_72436_e(rayTrace.field_72307_f)) < distance) && distance != 0.0) continue;
            entity = hitEntity;
            distance = squareDistanceTo;
        }
        return entity;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (compound.func_150297_b("Owner", 10)) {
            this.ownerNbt = compound.func_74775_l("Owner");
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        if (this.owner != null) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            UUID uuid = this.owner.func_110124_au();
            nbttagcompound.func_186854_a("OwnerUUID", uuid);
            compound.func_74782_a("Owner", (NBTBase)nbttagcompound);
        }
    }

    private void restoreOwnerFromSave() {
        if (this.ownerNbt != null && this.ownerNbt.func_186855_b("OwnerUUID")) {
            UUID uuid = this.ownerNbt.func_186857_a("OwnerUUID");
            for (EntityCamel entitycamel : this.field_70170_p.func_72872_a(EntityCamel.class, this.func_174813_aQ().func_186662_g(15.0))) {
                if (!entitycamel.func_110124_au().equals(uuid)) continue;
                this.owner = entitycamel;
                break;
            }
        }
        this.ownerNbt = null;
    }
}

