/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks;

import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.utils.IOreDictEntry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAtumRedstoneOre
extends Block
implements IOreDictEntry {
    private final boolean isLit;

    public BlockAtumRedstoneOre(boolean isLit) {
        super(Material.field_151576_e);
        this.isLit = isLit;
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
        if (isLit) {
            this.func_149715_a(0.625f);
            this.func_149675_a(true);
        }
    }

    public int func_149738_a(World world) {
        return 30;
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer playerIn) {
        this.activate(world, pos);
        super.func_180649_a(world, pos, playerIn);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        this.activate(world, pos);
        super.func_180634_a(world, pos, state, entity);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.activate(world, pos);
        return super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    private void activate(World world, BlockPos pos) {
        this.spawnParticles(world, pos);
        if (this == AtumBlocks.REDSTONE_ORE) {
            world.func_175656_a(pos, AtumBlocks.LIT_REDSTONE_ORE.func_176223_P());
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this == AtumBlocks.LIT_REDSTONE_ORE) {
            world.func_175656_a(pos, AtumBlocks.REDSTONE_ORE.func_176223_P());
        }
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151137_ax;
    }

    public int func_149679_a(int fortune, @Nonnull Random random) {
        return this.func_149745_a(random) + random.nextInt(fortune + 1);
    }

    public int func_149745_a(Random random) {
        return 4 + random.nextInt(2);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        if (this.func_180660_a(world.func_180495_p(pos), RANDOM, fortune) != Item.func_150898_a((Block)this)) {
            return 1 + RANDOM.nextInt(5);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (this.isLit) {
            this.spawnParticles(world, pos);
        }
    }

    private void spawnParticles(World world, BlockPos pos) {
        Random random = world.field_73012_v;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double x = (float)pos.func_177958_n() + random.nextFloat();
            double y = (float)pos.func_177956_o() + random.nextFloat();
            double z = (float)pos.func_177952_p() + random.nextFloat();
            if (i == 0 && !world.func_180495_p(pos.func_177984_a()).func_185914_p()) {
                y = (double)pos.func_177956_o() + d0 + 1.0;
            }
            if (i == 1 && !world.func_180495_p(pos.func_177977_b()).func_185914_p()) {
                y = (double)pos.func_177956_o() - d0;
            }
            if (i == 2 && !world.func_180495_p(pos.func_177968_d()).func_185914_p()) {
                z = (double)pos.func_177952_p() + d0 + 1.0;
            }
            if (i == 3 && !world.func_180495_p(pos.func_177978_c()).func_185914_p()) {
                z = (double)pos.func_177952_p() - d0;
            }
            if (i == 4 && !world.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                x = (double)pos.func_177958_n() + d0 + 1.0;
            }
            if (i == 5 && !world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                x = (double)pos.func_177958_n() - d0;
            }
            if (!(x < (double)pos.func_177958_n() || x > (double)(pos.func_177958_n() + 1) || y < 0.0 || y > (double)(pos.func_177956_o() + 1) || z < (double)pos.func_177952_p()) && !(z > (double)(pos.func_177952_p() + 1))) continue;
            world.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Nonnull
    protected ItemStack func_180643_i(@Nonnull IBlockState state) {
        return new ItemStack(AtumBlocks.REDSTONE_ORE);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack(AtumBlocks.REDSTONE_ORE, 1, this.func_180651_a(state));
    }

    @Override
    public void getOreDictEntries() {
        if (!this.isLit) {
            OreDictHelper.add(this, "ore", Objects.requireNonNull(this.getRegistryName()).func_110623_a().replace("_ore", ""));
        }
    }
}

