/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.lib.util;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.shinoow.abyssalcraft.api.necronomicon.CraftingStack;
import com.shinoow.abyssalcraft.api.necronomicon.INecroData;
import com.shinoow.abyssalcraft.api.necronomicon.NecroData;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class NecroDataJsonUtil {
    public static JsonObject serializeNecroData(NecroData data) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "necrodata");
        json.addProperty("version", (Number)1);
        json.addProperty("identifier", data.getIdentifier());
        json.addProperty("title", data.getTitle());
        JsonArray chapters = new JsonArray();
        json.add("chapters", (JsonElement)chapters);
        return json;
    }

    public static NecroData deserializeNecroData(JsonObject json) {
        if (NecroDataJsonUtil.getString(json, "type").equals("necrodata") && NecroDataJsonUtil.getInteger(json, "version") <= 1) {
            String identifier = NecroDataJsonUtil.getString(json, "identifier");
            String title = NecroDataJsonUtil.getString(json, "title");
            String information = NecroDataJsonUtil.getString(json, "information");
            JsonArray chapters = NecroDataJsonUtil.getArray(json, "chapters");
            NecroData.Chapter[] chaps = null;
            if (chapters != null) {
                chaps = new NecroData.Chapter[chapters.size()];
                for (int i = 0; i < chapters.size(); ++i) {
                    NecroData.Chapter c;
                    NecroData.Chapter[] e = chapters.get(i);
                    if (!e.isJsonObject() || (c = NecroDataJsonUtil.deserializeChapter(e.getAsJsonObject())) == null) continue;
                    chaps[i] = c;
                }
            }
            if (chaps != null) {
                int num = 0;
                for (JsonElement jsonElement : chaps) {
                    if (jsonElement == null) continue;
                    ++num;
                }
                if (num < chaps.length) {
                    NecroData.Chapter[] newchap = new NecroData.Chapter[num];
                    int newIndex = 0;
                    for (int i = 0; i < chaps.length; ++i) {
                        if (chaps[i] == null) continue;
                        newchap[newIndex] = chaps[i];
                        ++newIndex;
                    }
                    chaps = newchap;
                }
                return new NecroData(identifier, title, 0, information.length() == 0 ? null : information, (INecroData[])chaps);
            }
        }
        return null;
    }

    public static JsonObject serializeChapter(NecroData.Chapter chap) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "chapter");
        json.addProperty("version", (Number)1);
        json.addProperty("identifier", chap.getIdentifier());
        json.addProperty("title", chap.getTitle());
        JsonArray pages = new JsonArray();
        for (Map.Entry<Integer, NecroData.Page> e : chap.getPages().entrySet()) {
            pages.add((JsonElement)NecroDataJsonUtil.serializePage(e.getValue()));
        }
        json.add("pages", (JsonElement)pages);
        return json;
    }

    public static NecroData.Chapter deserializeChapter(JsonObject json) {
        if (NecroDataJsonUtil.getString(json, "type").equals("chapter") && NecroDataJsonUtil.getInteger(json, "version") <= 1) {
            String identifier = NecroDataJsonUtil.getString(json, "identifier");
            String title = NecroDataJsonUtil.getString(json, "title");
            NecroData.Chapter chapter = new NecroData.Chapter(identifier, title, 0);
            JsonArray pages = NecroDataJsonUtil.getArray(json, "pages");
            if (pages != null) {
                for (JsonElement e : pages) {
                    NecroData.Page p;
                    if (!e.isJsonObject() || (p = NecroDataJsonUtil.deserializePage(e.getAsJsonObject())) == null) continue;
                    chapter.addPage(p);
                }
            }
            return chapter;
        }
        return null;
    }

    public static JsonObject serializePage(NecroData.Page page) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "page");
        json.addProperty("version", (Number)1);
        json.addProperty("number", (Number)page.getPageNumber());
        NecroDataJsonUtil.serializeIcon(json, page.getIcon());
        json.addProperty("text", page.getText());
        return json;
    }

    public static NecroData.Page deserializePage(JsonObject json) {
        if (NecroDataJsonUtil.getString(json, "type").equals("page") && NecroDataJsonUtil.getInteger(json, "version") <= 1) {
            int num = NecroDataJsonUtil.getInteger(json, "number");
            Object icon = NecroDataJsonUtil.getIcon(json);
            String text = NecroDataJsonUtil.getString(json, "text");
            return new NecroData.Page(num, "Title", 0, icon, text);
        }
        return null;
    }

    private static void serializeIcon(JsonObject json, Object icon) {
        if (icon == null) {
            return;
        }
        if (!(icon instanceof ResourceLocation || icon instanceof ItemStack || icon instanceof CraftingStack)) {
            return;
        }
        if (icon instanceof ResourceLocation) {
            json.addProperty("icontype", "resourcelocation");
            json.addProperty("icon", icon.toString());
        } else if (icon instanceof ItemStack) {
            json.addProperty("icontype", "itemstack");
            json.addProperty("icon", NecroDataJsonUtil.stackToString((ItemStack)icon));
        } else if (icon instanceof CraftingStack) {
            json.addProperty("icontype", "craftingstack");
            JsonArray stuff = new JsonArray();
            stuff.add((JsonElement)new JsonPrimitive(NecroDataJsonUtil.outputStackToString(((CraftingStack)icon).getOutput())));
            for (ItemStack stack : ((CraftingStack)icon).getCraftingRecipe()) {
                stuff.add((JsonElement)new JsonPrimitive(NecroDataJsonUtil.stackToString(stack)));
            }
            json.add("icon", (JsonElement)stuff);
        } else if (icon instanceof String) {
            json.addProperty("icontype", "url");
            json.addProperty("icon", (String)icon);
        }
    }

    private static String stackToString(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return "";
        }
        return stack.func_77973_b().getRegistryName() + (stack.func_77952_i() > 0 ? ":" + stack.func_77952_i() : "");
    }

    private static String outputStackToString(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return "";
        }
        return stack.func_77973_b().getRegistryName() + ":" + stack.func_190916_E() + (stack.func_77952_i() > 0 ? ":" + stack.func_77952_i() : "");
    }

    private static String getString(JsonObject json, String id) {
        if (json == null) {
            return "";
        }
        if (json.has(id) && json.get(id).isJsonPrimitive() && json.get(id).getAsJsonPrimitive().isString()) {
            return json.get(id).getAsString();
        }
        return "";
    }

    private static String getStringValue(JsonElement json) {
        if (json == null) {
            return "";
        }
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            return json.getAsString();
        }
        return "";
    }

    public static int getInteger(JsonObject json, String id) {
        if (json == null) {
            return 0;
        }
        if (json.has(id) && json.get(id).isJsonPrimitive() && json.get(id).getAsJsonPrimitive().isNumber()) {
            return json.get(id).getAsInt();
        }
        return 0;
    }

    private static JsonArray getArray(JsonObject json, String id) {
        if (json == null) {
            return null;
        }
        if (json.has(id) && json.get(id).isJsonArray()) {
            return json.get(id).getAsJsonArray();
        }
        return null;
    }

    private static Object getIcon(JsonObject json) {
        if (json == null) {
            return null;
        }
        String type = NecroDataJsonUtil.getString(json, "icontype");
        if (type.length() == 0) {
            return null;
        }
        if (type.equals("resourcelocation")) {
            return new ResourceLocation(NecroDataJsonUtil.getString(json, "icon"));
        }
        if (type.equals("itemstack")) {
            return NecroDataJsonUtil.getStack(NecroDataJsonUtil.getString(json, "icon"));
        }
        if (type.equals("craftingstack")) {
            return NecroDataJsonUtil.getCStack(NecroDataJsonUtil.getArray(json, "icon"));
        }
        if (type.equals("url")) {
            return NecroDataJsonUtil.getString(json, "icon");
        }
        return null;
    }

    private static ItemStack getStack(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        String[] stuff = str.split(":");
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(stuff[0], stuff[1]));
        if (item != null) {
            return new ItemStack(item, 1, stuff.length == 3 ? Integer.valueOf(stuff[2]) : 0);
        }
        return null;
    }

    private static ItemStack getOutputStack(String str) {
        if (Strings.isNullOrEmpty((String)str)) {
            return null;
        }
        String[] stuff = str.split(":");
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(stuff[0], stuff[1]));
        if (item != null) {
            return new ItemStack(item, Integer.valueOf(stuff[2]).intValue(), stuff.length == 4 ? Integer.valueOf(stuff[3]) : 0);
        }
        return null;
    }

    private static CraftingStack getCStack(JsonArray array) {
        if (array == null) {
            return null;
        }
        ItemStack output = NecroDataJsonUtil.getOutputStack(NecroDataJsonUtil.getStringValue(array.get(0)));
        ItemStack[] recipe = new ItemStack[9];
        for (int i = 1; i < 10; ++i) {
            recipe[i - 1] = NecroDataJsonUtil.getStack(NecroDataJsonUtil.getStringValue(array.get(i)));
        }
        if (output != null) {
            return new CraftingStack(output, recipe);
        }
        return null;
    }

    public static JsonObject readNecroDataJsonFromFile(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            FileReader fr = new FileReader(file);
            JsonObject json = (JsonObject)new Gson().fromJson((Reader)fr, JsonObject.class);
            fr.close();
            return json;
        }
        catch (Exception e) {
            FMLLog.log((String)"AbyssalCraft", (Level)Level.ERROR, (String)"Failed to read JSON file: %s", (Object[])new Object[]{file.toString()});
            e.printStackTrace();
            return null;
        }
    }
}

