/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.integration.jei.transmutator;

import com.shinoow.abyssalcraft.api.recipe.TransmutatorRecipes;
import com.shinoow.abyssalcraft.integration.jei.transmutator.TransmutationRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IStackHelper;
import net.minecraft.item.ItemStack;

public class TransmutationRecipeMaker {
    @Nonnull
    public static List<TransmutationRecipe> getTransmutatorRecipes(IJeiHelpers helpers) {
        IStackHelper stackHelper = helpers.getStackHelper();
        TransmutatorRecipes transmutatorRecipes = TransmutatorRecipes.instance();
        Map<ItemStack, ItemStack> transmutationMap = TransmutationRecipeMaker.getTransmutationMap(transmutatorRecipes);
        ArrayList<TransmutationRecipe> recipes = new ArrayList<TransmutationRecipe>();
        for (Map.Entry<ItemStack, ItemStack> itemStackItemStackEntry : transmutationMap.entrySet()) {
            ItemStack input = itemStackItemStackEntry.getKey();
            ItemStack output = itemStackItemStackEntry.getValue();
            float experience = transmutatorRecipes.getExperience(output);
            List inputs = stackHelper.getSubtypes(input);
            TransmutationRecipe recipe = new TransmutationRecipe(inputs, output, experience);
            if (!TransmutationRecipeMaker.isRecipeValid(recipe)) continue;
            recipes.add(recipe);
        }
        return recipes;
    }

    private static boolean isRecipeValid(@Nonnull TransmutationRecipe recipe) {
        return recipe.getInputs().size() != 0 && recipe.getOutputs().size() > 0;
    }

    private static Map<ItemStack, ItemStack> getTransmutationMap(@Nonnull TransmutatorRecipes transmutatorRecipes) {
        return transmutatorRecipes.getTransmutationList();
    }
}

