/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.integration.jei.engraver;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

public class EngravingRecipeWrapper
implements IRecipeWrapper {
    @Nonnull
    private final List<List<ItemStack>> input;
    private final ItemStack engraving;
    @Nonnull
    private final List<ItemStack> output;
    @Nullable
    private final String experienceString;

    public EngravingRecipeWrapper(@Nonnull List<ItemStack> input, @Nonnull ItemStack engraving, @Nonnull ItemStack output, float experience) {
        this.input = Collections.singletonList(input);
        this.engraving = engraving;
        this.output = Collections.singletonList(output);
        this.experienceString = (double)experience > 0.0 ? I18n.func_135052_a((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)}) : null;
    }

    @Nonnull
    public List<List<ItemStack>> getInputs() {
        return this.input;
    }

    @Nonnull
    public ItemStack getEngraving() {
        return this.engraving;
    }

    @Nonnull
    public List<ItemStack> getOutputs() {
        return this.output;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.experienceString != null) {
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            fontRendererObj.func_78276_b(this.experienceString, 69 - fontRendererObj.func_78256_a(this.experienceString) / 2, 0, Color.gray.getRGB());
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>(this.input);
        inputs.add(Collections.singletonList(this.engraving));
        ingredients.setInputLists(ItemStack.class, inputs);
        ingredients.setOutputs(ItemStack.class, this.output);
    }
}

