/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.structures.omothol;

import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityCrate;
import com.shinoow.abyssalcraft.lib.ACLoot;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class StructureStorage
extends WorldGenerator {
    private Set<BlockPos> positions = new HashSet<BlockPos>();

    public boolean tooClose(BlockPos pos) {
        return this.positions.stream().anyMatch(b -> b.func_185332_f(pos.func_177958_n(), b.func_177956_o(), pos.func_177952_p()) <= 300.0);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos pos) {
        while (worldIn.func_175623_d(pos) && pos.func_177956_o() > 2) {
            pos = pos.func_177977_b();
        }
        if (pos.func_177956_o() <= 1) {
            return false;
        }
        Rotation[] arotation = Rotation.values();
        PlacementSettings placeSettings = new PlacementSettings().func_186220_a(arotation[rand.nextInt(arotation.length)]).func_186225_a(Blocks.field_189881_dj);
        BlockPos center = pos;
        BlockPos crates = pos;
        int distX = 8;
        int distZ = 9;
        switch (placeSettings.func_186215_c()) {
            case CLOCKWISE_180: {
                pos = pos.func_177982_a(16, 0, 18);
                center = pos.func_177964_d(distZ).func_177985_f(distX);
                crates = pos.func_177964_d(4).func_177985_f(4);
                break;
            }
            case CLOCKWISE_90: {
                distX = 9;
                distZ = 8;
                pos = pos.func_177982_a(18, 0, 0);
                center = pos.func_177970_e(distZ).func_177985_f(distX);
                crates = pos.func_177970_e(4).func_177985_f(4);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                distX = 9;
                distZ = 8;
                pos = pos.func_177982_a(0, 0, 16);
                center = pos.func_177964_d(distZ).func_177965_g(distX);
                crates = pos.func_177964_d(4).func_177965_g(4);
                break;
            }
            case NONE: {
                pos = pos.func_177982_a(0, 0, 0);
                center = pos.func_177970_e(distZ).func_177965_g(distX);
                crates = pos.func_177970_e(4).func_177965_g(4);
                break;
            }
            default: {
                pos = pos.func_177982_a(0, 0, 0);
                center = pos.func_177970_e(distZ).func_177965_g(distX);
                crates = pos.func_177970_e(4).func_177965_g(4);
            }
        }
        if (worldIn.func_180495_p(center).func_177230_c() != ACBlocks.stone || worldIn.func_180495_p(center.func_177964_d(distZ)).func_177230_c() != ACBlocks.stone || worldIn.func_180495_p(center.func_177970_e(distZ)).func_177230_c() != ACBlocks.stone || worldIn.func_180495_p(center.func_177985_f(distX)).func_177230_c() != ACBlocks.stone || worldIn.func_180495_p(center.func_177965_g(distX)).func_177230_c() != ACBlocks.stone) {
            return false;
        }
        if ((center = worldIn.func_175645_m(center)).func_177956_o() > pos.func_177956_o()) {
            pos = pos.func_177981_b(center.func_177956_o() - pos.func_177956_o());
            crates = crates.func_177981_b(center.func_177956_o() - crates.func_177956_o());
        }
        MinecraftServer server = worldIn.func_73046_m();
        TemplateManager templateManager = worldIn.func_72860_G().func_186340_h();
        Template template = templateManager.func_186237_a(server, new ResourceLocation("abyssalcraft", "omothol/storage"));
        template.func_186253_b(worldIn, pos, placeSettings);
        this.positions.add(pos);
        int num = rand.nextInt(4) + 1;
        boolean treasure = false;
        template = templateManager.func_186237_a(server, new ResourceLocation("abyssalcraft", "omothol/crates_" + num));
        template.func_186253_b(worldIn, crates, placeSettings);
        Map map = template.func_186258_a(crates, placeSettings);
        for (Map.Entry entry : map.entrySet()) {
            if (!((String)entry.getValue()).startsWith("crate")) continue;
            worldIn.func_175656_a((BlockPos)entry.getKey(), ACBlocks.wooden_crate.func_176223_P());
            TileEntityCrate crate = (TileEntityCrate)worldIn.func_175625_s((BlockPos)entry.getKey());
            if (crate == null) continue;
            boolean chance = treasure ? false : worldIn.field_73012_v.nextInt(5) == 0;
            crate.func_189404_a(this.getLootTable(chance), worldIn.field_73012_v.nextLong());
            if (!chance) continue;
            treasure = true;
        }
        return true;
    }

    private ResourceLocation getLootTable(boolean treasure) {
        return treasure ? ACLoot.CHEST_OMOTHOL_STORAGE_TREASURE : ACLoot.CHEST_OMOTHOL_STORAGE_JUNK;
    }
}

