/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.spells;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.energy.IEnergyContainerItem;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.api.spell.Spell;
import com.shinoow.abyssalcraft.common.blocks.BlockACCobblestone;
import com.shinoow.abyssalcraft.common.blocks.BlockACStone;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntropySpell
extends Spell {
    public EntropySpell() {
        super("entropy", 0.0f, Items.field_151044_h, new ItemStack(ACBlocks.cobblestone, 1, 0));
        this.setParchment(new ItemStack(ACItems.scroll, 1, 3));
        this.setColor(1515368);
    }

    @Override
    public boolean canCastSpell(World world, BlockPos pos, EntityPlayer player) {
        RayTraceResult r = this.rayTrace(player, world, 16.0, 1.0f);
        if (r != null && r.field_72313_a == RayTraceResult.Type.BLOCK) {
            return this.getDegradation(world.func_180495_p(r.func_178782_a())) != null;
        }
        return false;
    }

    private IBlockState getDegradation(IBlockState state) {
        if (state.func_177230_c() == ACBlocks.stone) {
            switch ((BlockACStone.EnumStoneType)((Object)state.func_177229_b(BlockACStone.TYPE))) {
                case ABYSSALNITE_STONE: {
                    return ACBlocks.cobblestone.func_176223_P().func_177226_a(BlockACCobblestone.TYPE, (Comparable)((Object)BlockACCobblestone.EnumCobblestoneType.ABYSSALNITE_STONE));
                }
                case ABYSSAL_STONE: {
                    return ACBlocks.cobblestone.func_176223_P().func_177226_a(BlockACCobblestone.TYPE, (Comparable)((Object)BlockACCobblestone.EnumCobblestoneType.ABYSSAL_STONE));
                }
                case CORALIUM_STONE: {
                    return ACBlocks.cobblestone.func_176223_P().func_177226_a(BlockACCobblestone.TYPE, (Comparable)((Object)BlockACCobblestone.EnumCobblestoneType.CORALIUM_STONE));
                }
                case DARKSTONE: {
                    return ACBlocks.cobblestone.func_176223_P().func_177226_a(BlockACCobblestone.TYPE, (Comparable)((Object)BlockACCobblestone.EnumCobblestoneType.DARKSTONE));
                }
                case DREADSTONE: {
                    return ACBlocks.cobblestone.func_176223_P().func_177226_a(BlockACCobblestone.TYPE, (Comparable)((Object)BlockACCobblestone.EnumCobblestoneType.DREADSTONE));
                }
            }
            return null;
        }
        if (state.func_177230_c() == Blocks.field_150348_b) {
            return Blocks.field_150347_e.func_176223_P();
        }
        if (state.func_177230_c() == ACBlocks.cobblestone || state.func_177230_c() == Blocks.field_150347_e) {
            return Blocks.field_150351_n.func_176223_P();
        }
        if (state.func_177230_c() == Blocks.field_150351_n) {
            return Blocks.field_150354_m.func_176223_P();
        }
        if (state.func_177230_c() == Blocks.field_150354_m) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return null;
    }

    public RayTraceResult rayTrace(EntityPlayer player, World world, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = player.func_174824_e(partialTicks);
        Vec3d vec3d1 = player.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return world.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    @Override
    protected void castSpellClient(World world, BlockPos pos, EntityPlayer player) {
    }

    @Override
    protected void castSpellServer(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state;
        RayTraceResult r = this.rayTrace(player, world, 16.0, 1.0f);
        if (r != null && r.field_72313_a == RayTraceResult.Type.BLOCK && (state = this.getDegradation(world.func_180495_p(r.func_178782_a()))) != null && world.func_175660_a(player, r.func_178782_a())) {
            world.func_175655_b(r.func_178782_a(), false);
            world.func_175656_a(r.func_178782_a(), state);
            AbyssalCraftAPI.getInternalMethodHandler().spawnPEStream(pos, r.func_178782_a(), world.field_73011_w.getDimension());
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof IEnergyContainerItem)) continue;
                ((IEnergyContainerItem)stack.func_77973_b()).addEnergy(stack, 5 + world.field_73012_v.nextInt(5));
                break;
            }
        }
    }
}

