/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.entity.anti;

import com.shinoow.abyssalcraft.api.entity.IAntiEntity;
import com.shinoow.abyssalcraft.common.entity.ai.EntityAIAntiCreeperSwell;
import com.shinoow.abyssalcraft.common.entity.anti.EntityAntiSkeleton;
import com.shinoow.abyssalcraft.common.util.ExplosionUtil;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLoot;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAntiCreeper
extends EntityMob
implements IAntiEntity {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityAntiCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityAntiCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityAntiCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;
    private int explosionRadius = 10;

    public EntityAntiCreeper(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAntiCreeperSwell(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCreeper.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        if (ACConfig.hardcoreMode) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        }
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    public void func_180430_e(float par1, float par2) {
        super.func_180430_e(par1, par2);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + par1 * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            par1NBTTagCompound.func_74757_a("powered", true);
        }
        par1NBTTagCompound.func_74777_a("Fuse", (short)this.fuseTime);
        par1NBTTagCompound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        par1NBTTagCompound.func_74757_a("ignited", this.hasIgnited());
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.field_70180_af.func_187227_b(POWERED, (Object)par1NBTTagCompound.func_74767_n("powered"));
        if (par1NBTTagCompound.func_150297_b("Fuse", 99)) {
            this.fuseTime = par1NBTTagCompound.func_74765_d("Fuse");
        }
        if (par1NBTTagCompound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = par1NBTTagCompound.func_74771_c("ExplosionRadius");
        }
        if (par1NBTTagCompound.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187570_aq;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        super.func_70645_a(par1DamageSource);
        if (par1DamageSource.func_76346_g() instanceof EntityAntiSkeleton) {
            int i = Item.func_150891_b((Item)Items.field_151096_cd);
            int j = Item.func_150891_b((Item)Items.field_151084_co);
            int k = i + this.field_70146_Z.nextInt(j - i + 1);
            this.func_145779_a(Item.func_150899_d((int)k), 1);
        }
    }

    protected void func_82167_n(Entity par1Entity) {
        if (!this.field_70170_p.field_72995_K && par1Entity instanceof EntityCreeper) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            if (ACConfig.nuclearAntimatterExplosions) {
                ExplosionUtil.newODBExplosion(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, ACConfig.antimatterExplosionSize, true, flag);
            } else {
                this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0f, flag);
            }
            this.func_70106_y();
        } else {
            par1Entity.func_70108_f((Entity)this);
        }
    }

    public boolean func_70652_k(Entity par1Entity) {
        return true;
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float par1) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * par1) / (float)(this.fuseTime - 2);
    }

    protected Item func_146068_u() {
        return Items.field_151016_H;
    }

    protected ResourceLocation func_184647_J() {
        return ACLoot.ENTITY_ANTI_CREEPER;
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand p_184645_2_) {
        ItemStack stack = player.func_184586_b(p_184645_2_);
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(p_184645_2_);
            if (!this.field_70170_p.field_72995_K) {
                this.ignite();
                stack.func_77972_a(1, (EntityLivingBase)player);
                return true;
            }
        }
        return super.func_184645_a(player, p_184645_2_);
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag = this.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            float f = this.getPowered() ? 2.0f : 1.0f;
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionRadius * f, flag);
            this.func_70106_y();
        }
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }
}

