/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks;

import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.lib.ACTabs;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockACStone
extends Block {
    public static final PropertyEnum<EnumStoneType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumStoneType.class);

    public BlockACStone() {
        super(Material.field_151576_e);
        this.func_180632_j(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumStoneType.DARKSTONE)));
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(ACTabs.tabBlock);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149675_a(true);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess p_180659_2_, BlockPos p_180659_3_) {
        return ((EnumStoneType)((Object)state.func_177229_b(TYPE))).getMapColor();
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        return ((EnumStoneType)((Object)blockState.func_177229_b(TYPE))).getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return ((EnumStoneType)((Object)world.func_180495_p(pos).func_177229_b(TYPE))).getResistance();
    }

    public int getHarvestLevel(IBlockState state) {
        return ((EnumStoneType)((Object)state.func_177229_b(TYPE))).getHarvestLevel();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumStoneType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumStoneType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityDragon) {
            return state.func_177229_b(TYPE) != EnumStoneType.OMOTHOL_STONE && state.func_177229_b(TYPE) != EnumStoneType.ETHAXIUM;
        }
        if (entity instanceof EntityWither || entity instanceof EntityWitherSkull) {
            return state.func_177229_b(TYPE) != EnumStoneType.ETHAXIUM;
        }
        return super.canEntityDestroy(state, world, pos, entity);
    }

    public void func_180650_b(World par1World, BlockPos pos, IBlockState state, Random par5Random) {
        if (!par1World.field_72995_K && state.func_177229_b(TYPE) == EnumStoneType.CORALIUM_STONE) {
            for (EnumFacing face : EnumFacing.values()) {
                if (par1World.func_180495_p(pos.func_177972_a(face)).func_177230_c() != ACBlocks.liquid_coralium || !((double)par5Random.nextFloat() < 0.3)) continue;
                par1World.func_175656_a(pos.func_177972_a(face), state);
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random random, int j) {
        return this.func_180651_a(state) < 5 ? Item.func_150898_a((Block)ACBlocks.cobblestone) : super.func_180660_a(state, random, j);
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumStoneType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public void func_149666_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        for (int i = 0; i < EnumStoneType.values().length; ++i) {
            par3List.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{TYPE}).build();
    }

    public static enum EnumStoneType implements IStringSerializable
    {
        DARKSTONE(0, "darkstone", "darkstone", 0, 1.65f, 12.0f, MapColor.field_151646_E),
        ABYSSAL_STONE(1, "abyssalstone", "abystone", 2, 1.8f, 12.0f, MapColor.field_151651_C),
        DREADSTONE(2, "dreadstone", "dreadstone", 4, 2.5f, 20.0f, MapColor.field_151645_D),
        ABYSSALNITE_STONE(3, "abyssalnitestone", "abydreadstone", 4, 2.5f, 20.0f, MapColor.field_151678_z),
        CORALIUM_STONE(4, "coraliumstone", "cstone", 0, 1.5f, 10.0f, MapColor.field_151679_y),
        ETHAXIUM(5, "ethaxium", "ethaxium", 8, 100.0f, Float.MAX_VALUE, MapColor.field_151659_e),
        OMOTHOL_STONE(6, "omotholstone", "omotholstone", 6, 10.0f, 12.0f, MapColor.field_151646_E),
        MONOLITH_STONE(7, "monolithstone", "monolithstone", 0, 6.0f, 24.0f, MapColor.field_151646_E);

        private static final EnumStoneType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String state;
        private final int harvest;
        private final float hardness;
        private final float resistance;
        private final MapColor mapColor;

        private EnumStoneType(int meta, String name, String state, int harvest, float hardness, float resistance, MapColor mapColor) {
            this.meta = meta;
            this.name = name;
            this.state = state;
            this.harvest = harvest;
            this.hardness = hardness;
            this.resistance = resistance;
            this.mapColor = mapColor;
        }

        public int getMeta() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public int getHarvestLevel() {
            return this.harvest;
        }

        public float getHardness() {
            return this.hardness;
        }

        public float getResistance() {
            return this.resistance;
        }

        public String toString() {
            return this.name;
        }

        public String getState() {
            return this.state;
        }

        public static EnumStoneType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumStoneType[EnumStoneType.values().length];
            EnumStoneType[] enumStoneTypeArray = EnumStoneType.values();
            int n = enumStoneTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumStoneType enumtype;
                EnumStoneType.META_LOOKUP[enumtype.getMeta()] = enumtype = enumStoneTypeArray[i];
            }
        }
    }
}

