/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.rending;

import java.util.function.Predicate;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;

public class Rending {
    private final String name;
    private final String jeiDescription;
    private final int maxEnergy;
    private final int dimension;
    private final ItemStack output;
    private final Predicate<EntityLiving> rendingPredicate;

    public Rending(String name, int maxEnergy, ItemStack output, Predicate<EntityLiving> rendingPredicate, String jeiDescription, int dimension) {
        this.name = name;
        this.maxEnergy = maxEnergy;
        this.output = output;
        this.rendingPredicate = rendingPredicate;
        this.jeiDescription = jeiDescription;
        this.dimension = dimension;
    }

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return String.format("tooltip.drainstaff.energy.%s", this.name.toLowerCase());
    }

    public String getJeiDescription() {
        return this.jeiDescription;
    }

    public int getMaxEnergy() {
        return this.maxEnergy;
    }

    public int getDimension() {
        return this.dimension;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public Predicate<EntityLiving> getRendingFunction() {
        return this.rendingPredicate;
    }

    public boolean isApplicable(EntityLiving entity) {
        return this.rendingPredicate.test(entity);
    }
}

