/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.ae2wtlib.api.client;

import appeng.api.storage.data.IAEItemStack;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import p455w0rd.ae2wtlib.api.client.StackSizeRenderer;

public class ItemStackSizeRenderer
extends StackSizeRenderer<IAEItemStack> {
    private static final ItemStackSizeRenderer INSTANCE = new ItemStackSizeRenderer();

    public static final ItemStackSizeRenderer getInstance() {
        return INSTANCE;
    }

    @Override
    public void renderStackSize(FontRenderer fontRenderer, IAEItemStack aeStack, int xPos, int yPos) {
        if (aeStack != null) {
            int Y;
            int X;
            float scaleFactor = AEConfig.instance().useTerminalUseLargeFont() ? 0.85f : 0.5f;
            float inverseScaleFactor = 1.0f / scaleFactor;
            int offset = AEConfig.instance().useTerminalUseLargeFont() ? 0 : -1;
            boolean unicodeFlag = fontRenderer.func_82883_a();
            fontRenderer.func_78264_a(false);
            if ((aeStack.getStackSize() == 0L || GuiScreen.func_175283_s()) && aeStack.isCraftable()) {
                String craftLabelText = AEConfig.instance().useTerminalUseLargeFont() ? GuiText.LargeFontCraft.getLocal() : GuiText.SmallFontCraft.getLocal();
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
                X = (int)(((float)xPos + (float)offset + 16.0f - (float)fontRenderer.func_78256_a(craftLabelText) * scaleFactor) * inverseScaleFactor);
                Y = (int)(((float)yPos + (float)offset + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
                fontRenderer.func_175063_a(craftLabelText, (float)X, (float)Y, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
            }
            if (aeStack.getStackSize() > 0L && (!aeStack.isCraftable() || aeStack.isCraftable() && !GuiScreen.func_175283_s())) {
                String stackSize = this.getToBeRenderedStackSize(aeStack.getStackSize());
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scaleFactor, (float)scaleFactor, (float)scaleFactor);
                X = (int)(((float)xPos + (float)offset + 16.0f - (float)fontRenderer.func_78256_a(stackSize) * scaleFactor) * inverseScaleFactor);
                Y = (int)(((float)yPos + (float)offset + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
                fontRenderer.func_175063_a(stackSize, (float)X, (float)Y, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
            }
            fontRenderer.func_78264_a(unicodeFlag);
        }
    }

    private String getToBeRenderedStackSize(long originalSize) {
        if (AEConfig.instance().useTerminalUseLargeFont()) {
            return this.getConverter().toSlimReadableForm(originalSize);
        }
        return this.getConverter().toWideReadableForm(originalSize);
    }
}

