/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.logic;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.logic.enums.LogicMode;
import mcjty.xnet.utils.CastTools;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import terrails.xnetgases.Constants;
import terrails.xnetgases.module.logic.ChemicalSensor;

public class ChemicalLogicConnectorSettings
extends AbstractConnectorSettings {
    private static final Set<String> TAGS = ImmutableSet.of((Object)"rsout", (Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object[])new String[]{"color3"});
    public static final int SENSORS = 4;
    private LogicMode connectorMode = LogicMode.SENSOR;
    private final List<ChemicalSensor> sensors = new ArrayList<ChemicalSensor>(4);
    private int colors;
    private Integer redstoneOut;

    public ChemicalLogicConnectorSettings(@Nonnull Direction side) {
        super(side);
        for (int i = 0; i < 4; ++i) {
            this.sensors.add(new ChemicalSensor(i));
        }
    }

    public List<ChemicalSensor> getSensors() {
        return this.sensors;
    }

    public void setColorMask(int colors) {
        this.colors = colors;
    }

    public int getColorMask() {
        return this.colors;
    }

    public Integer getRedstoneOut() {
        return this.redstoneOut;
    }

    public boolean isEnabled(String tag) {
        if (tag.equals("facing")) {
            return this.advanced && this.connectorMode != LogicMode.OUTPUT;
        }
        if (tag.equals("operation_speed")) {
            return true;
        }
        for (ChemicalSensor sensor : this.sensors) {
            if (!sensor.isEnabled(tag)) continue;
            return true;
        }
        return TAGS.contains(tag);
    }

    public LogicMode getConnectorMode() {
        return this.connectorMode;
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().translatableChoices("mode", (ITranslatableEnum)this.connectorMode, (ITranslatableEnum[])LogicMode.values()).nl();
        switch (this.connectorMode) {
            case SENSOR: {
                this.sensors.forEach(sensor -> sensor.createGui(gui));
                break;
            }
            case OUTPUT: {
                gui.label(I18nConstants.LOGIC_RS_LABEL.i18n(new Object[0])).integer("rsout", I18nConstants.LOGIC_RS_TOOLTIP.i18n(new Object[0]), this.redstoneOut, 40, 15, 0).nl();
            }
        }
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.connectorMode = CastTools.safeLogicMode((Object)data.get("mode"));
        if (this.connectorMode == LogicMode.SENSOR) {
            this.sensors.forEach(sensors -> sensors.update(data));
        } else {
            this.redstoneOut = (Integer)data.get("rsout");
        }
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128344_("mode", (byte)this.connectorMode.ordinal());
        tag.m_128405_("colors", this.colors);
        this.sensors.forEach(sensor -> sensor.writeToNBT(tag));
        if (this.redstoneOut != null) {
            tag.m_128405_("rsout", this.redstoneOut.intValue());
        }
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.connectorMode = LogicMode.values()[tag.m_128445_("mode")];
        this.colors = tag.m_128451_("colors");
        this.sensors.forEach(sensor -> sensor.readFromNBT(tag));
        this.redstoneOut = tag.m_128451_("rsout");
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return switch (this.connectorMode) {
            default -> throw new IncompatibleClassChangeError();
            case LogicMode.SENSOR -> new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 26, 70, 13, 10);
            case LogicMode.OUTPUT -> new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 39, 70, 13, 10);
        };
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        ChemicalLogicConnectorSettings.setEnumSafe((JsonObject)object, (String)"mode", (Enum)this.connectorMode);
        JsonArray sensorArray = new JsonArray();
        for (ChemicalSensor sensor : this.sensors) {
            JsonObject o = new JsonObject();
            sensor.writeToJson(o);
            sensorArray.add((JsonElement)o);
        }
        object.add("sensors", (JsonElement)sensorArray);
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.connectorMode = (LogicMode)ChemicalLogicConnectorSettings.getEnumSafe((JsonObject)object, (String)"logicMode", EnumStringTranslators::getLogicMode);
        JsonArray sensorArray = object.get("sensors").getAsJsonArray();
        this.sensors.clear();
        for (JsonElement oe : sensorArray) {
            JsonObject o = oe.getAsJsonObject();
            ChemicalSensor sensor = new ChemicalSensor(this.sensors.size());
            sensor.readFromJson(o);
            this.sensors.add(sensor);
        }
    }
}

