/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.module.logic;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.DefaultChannelSettings;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.rftoolsbase.api.xnet.tiles.IConnectorTile;
import mcjty.xnet.apiimpl.ConnectedBlock;
import mcjty.xnet.apiimpl.ConnectedEntity;
import mcjty.xnet.apiimpl.logic.ConnectedOptionalEntity;
import mcjty.xnet.apiimpl.logic.enums.LogicMode;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import terrails.xnetgases.Constants;
import terrails.xnetgases.module.logic.ChemicalLogicConnectorSettings;
import terrails.xnetgases.module.logic.ChemicalSensor;

public class ChemicalLogicChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    private int colors = 0;
    private List<ConnectedOptionalEntity<ChemicalLogicConnectorSettings>> sensors = null;
    private List<ConnectedBlock<ChemicalLogicConnectorSettings>> outputs = null;

    public JsonObject writeToJson() {
        return new JsonObject();
    }

    public void readFromNBT(CompoundTag tag) {
        this.colors = tag.m_128451_("colors");
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128405_("colors", this.colors);
    }

    public void tick(int channel, IControllerContext context) {
        ChemicalLogicConnectorSettings settings;
        this.updateCache(channel, context);
        Level level = context.getControllerWorld();
        this.colors = 0;
        for (ConnectedOptionalEntity<ChemicalLogicConnectorSettings> connectedOptionalEntity : this.sensors) {
            settings = (ChemicalLogicConnectorSettings)((Object)connectedOptionalEntity.settings());
            int sensorColors = 0;
            BlockPos pos = connectedOptionalEntity.getBlockPos();
            if (!LevelTools.isLoaded((Level)level, (BlockPos)pos)) {
                this.colors |= settings.getColorMask();
                continue;
            }
            if (this.checkRedstone(settings, (IConnectorTile)connectedOptionalEntity.getConnectorEntity(), context)) {
                BlockEntity te = connectedOptionalEntity.getConnectedEntity();
                for (ChemicalSensor sensor : settings.getSensors()) {
                    if (!sensor.test(te, settings)) continue;
                    sensorColors |= 1 << sensor.getOutputColor().ordinal();
                }
            }
            settings.setColorMask(sensorColors);
            this.colors |= sensorColors;
        }
        for (ConnectedBlock connectedBlock : this.outputs) {
            settings = (ChemicalLogicConnectorSettings)((Object)connectedBlock.settings());
            BlockPos connectorPos = connectedBlock.connectorPos();
            Direction side = connectedBlock.sidedConsumer().side();
            if (!LevelTools.isLoaded((Level)level, (BlockPos)connectorPos)) continue;
            ConnectorTileEntity connectorTileEntity = connectedBlock.getConnectorEntity();
            int powerOut = this.checkRedstone(settings, (IConnectorTile)connectorTileEntity, context) ? (settings.getRedstoneOut() == null ? 0 : settings.getRedstoneOut()) : 0;
            connectorTileEntity.setPowerOut(side, powerOut);
        }
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.sensors == null || this.outputs == null) {
            ConnectedBlock<ChemicalLogicConnectorSettings> connectedBlock;
            ChemicalLogicConnectorSettings con;
            this.sensors = new ArrayList<ConnectedOptionalEntity<ChemicalLogicConnectorSettings>>();
            this.outputs = new ArrayList<ConnectedBlock<ChemicalLogicConnectorSettings>>();
            Level world = context.getControllerWorld();
            Map connectors = context.getConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                connectedBlock = this.getConnectedBlockInfo(context, entry, world, con = (ChemicalLogicConnectorSettings)((Object)entry.getValue()));
                if (connectedBlock == null) continue;
                if (con.getConnectorMode() == LogicMode.SENSOR) {
                    ConnectedOptionalEntity<ChemicalLogicConnectorSettings> connectedEntity = this.getConnectedEntity(connectedBlock, world);
                    this.sensors.add(connectedEntity);
                    continue;
                }
                this.outputs.add(connectedBlock);
            }
            connectors = context.getRoutedConnectors(channel);
            for (Map.Entry<SidedConsumer, IConnectorSettings> entry : connectors.entrySet()) {
                con = (ChemicalLogicConnectorSettings)((Object)entry.getValue());
                if (con.getConnectorMode() != LogicMode.OUTPUT) continue;
                connectedBlock = this.getConnectedBlockInfo(context, entry, world, con);
                this.outputs.add(connectedBlock);
            }
        }
    }

    @Nonnull
    private ConnectedOptionalEntity<ChemicalLogicConnectorSettings> getConnectedEntity(@Nonnull ConnectedBlock<ChemicalLogicConnectorSettings> connectedBlock, @Nonnull Level world) {
        BlockEntity connectedEntity = world.m_7702_(connectedBlock.getBlockPos());
        return new ConnectedOptionalEntity(connectedBlock, connectedEntity);
    }

    @Nullable
    private ConnectedBlock<ChemicalLogicConnectorSettings> getConnectedBlockInfo(IControllerContext context, Map.Entry<SidedConsumer, IConnectorSettings> entry, @Nonnull Level world, @Nonnull ChemicalLogicConnectorSettings con) {
        BlockPos connectorPos = context.findConsumerPosition(entry.getKey().consumerId());
        if (connectorPos == null) {
            return null;
        }
        ConnectorTileEntity connectorEntity = (ConnectorTileEntity)world.m_7702_(connectorPos);
        if (connectorEntity == null) {
            return null;
        }
        BlockPos connectedBlockPos = connectorPos.m_121945_(entry.getKey().side());
        BlockEntity connectedEntity = world.m_7702_(connectedBlockPos);
        if (connectedEntity == null) {
            return new ConnectedBlock(entry.getKey(), (Object)con, connectorPos, connectedBlockPos, connectorEntity);
        }
        return new ConnectedEntity(entry.getKey(), (Object)con, connectorPos, connectedBlockPos, connectedEntity, connectorEntity);
    }

    public void cleanCache() {
        this.sensors = null;
        this.outputs = null;
    }

    public int getColors() {
        return this.colors;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(Constants.XNET_GUI_ELEMENTS, 11, 90, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String s) {
        return true;
    }

    public void createGui(IEditorGui iEditorGui) {
    }

    public void update(Map<String, Object> map) {
    }
}

