/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GuiParser;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ChoiceEvent;
import mcjty.lib.gui.widgets.AbstractLabel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import org.apache.commons.lang3.ArrayUtils;

public class ChannelChoiceLabel
extends AbstractLabel<ChannelChoiceLabel> {
    public static final String TYPE_CHANNEL_CHOICE_LABEL = "channelchoicelabel";
    public static final Key<String> PARAM_CHOICE = new Key("choice", Type.STRING);
    public static final Key<Integer> PARAM_CHOICE_IDX = new Key("choiceIdx", Type.INTEGER);
    private Integer choiceIndex = null;
    private IChannelType[] choices = null;
    private final Map<IChannelType, List<String>> tooltipMap = new HashMap<IChannelType, List<String>>();
    private List<ChoiceEvent<String>> choiceEvents = null;

    public ChannelChoiceLabel() {
        this.text("");
    }

    private void setCurrentChoice(IChannelType choice) {
        this.choiceIndex = ArrayUtils.indexOf((Object[])this.choices, (Object)choice);
    }

    public String getCurrentChoice() {
        return this.choices[this.choiceIndex].getID();
    }

    public ChannelChoiceLabel choices(IChannelType[] choices) {
        this.choices = choices;
        if (this.choiceIndex == null) {
            this.choiceIndex = 0;
            this.text(choices[0].getName());
            this.fireChoiceEvents(choices[0].getID());
        }
        if (this.tooltipMap.isEmpty()) {
            for (IChannelType choice : choices) {
                this.setChoiceTooltip(choice);
            }
        }
        return this;
    }

    public ChannelChoiceLabel setChoiceTooltip(IChannelType choice) {
        this.tooltipMap.put(choice, Collections.singletonList(choice.getName()));
        return this;
    }

    public ChannelChoiceLabel choice(ITranslatableEnum<?> choice) {
        if (Objects.equals(this.choiceIndex, choice.ordinal())) {
            return this;
        }
        this.choiceIndex = choice.ordinal();
        this.text(choice.getI18n());
        return this;
    }

    public List<String> getTooltips() {
        List<String> tooltips = this.tooltipMap.get(this.choices[this.choiceIndex]);
        if (tooltips == null) {
            return super.getTooltips();
        }
        return tooltips;
    }

    public void draw(Screen gui, GuiGraphics graphics, int x, int y) {
        if (!this.visible) {
            return;
        }
        int xx = x + this.bounds.x;
        int yy = y + this.bounds.y;
        if (this.isEnabled()) {
            if (this.isHovering()) {
                this.drawStyledBoxHovering(this.window, graphics, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1);
            } else {
                this.drawStyledBoxNormal(this.window, graphics, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1);
            }
            RenderHelper.drawLeftTriangle((GuiGraphics)graphics, (int)(xx + this.bounds.width - 10), (int)(yy + this.bounds.height / 2), (int)StyleConfig.colorCycleButtonTriangleNormal);
            RenderHelper.drawRightTriangle((GuiGraphics)graphics, (int)(xx + this.bounds.width - 4), (int)(yy + this.bounds.height / 2), (int)StyleConfig.colorCycleButtonTriangleNormal);
        } else {
            this.drawStyledBoxDisabled(this.window, graphics, xx, yy, xx + this.bounds.width - 1, yy + this.bounds.height - 1);
            RenderHelper.drawLeftTriangle((GuiGraphics)graphics, (int)(xx + this.bounds.width - 10), (int)(yy + this.bounds.height / 2), (int)StyleConfig.colorCycleButtonTriangleDisabled);
            RenderHelper.drawRightTriangle((GuiGraphics)graphics, (int)(xx + this.bounds.width - 4), (int)(yy + this.bounds.height / 2), (int)StyleConfig.colorCycleButtonTriangleDisabled);
        }
        super.drawOffset(gui, graphics, x, y, -3, 1);
    }

    public Widget<?> mouseClick(double x, double y, int button) {
        if (this.isEnabledAndVisible()) {
            if (this.choices.length == 0) {
                return null;
            }
            if (button == 1 || SafeClientTools.isSneaking()) {
                Integer n = this.choiceIndex;
                this.choiceIndex = this.choiceIndex - 1;
                if (this.choiceIndex < 0) {
                    this.choiceIndex = this.choices.length - 1;
                }
            } else {
                Integer n = this.choiceIndex;
                this.choiceIndex = this.choiceIndex + 1;
                if (this.choiceIndex >= this.choices.length) {
                    this.choiceIndex = 0;
                }
            }
            this.text(this.choices[this.choiceIndex].getName());
            this.fireChoiceEvents(this.choices[this.choiceIndex].getID());
        }
        return null;
    }

    public ChannelChoiceLabel event(ChoiceEvent<String> event) {
        if (this.choiceEvents == null) {
            this.choiceEvents = new ArrayList<ChoiceEvent<String>>();
        }
        this.choiceEvents.add(event);
        return this;
    }

    public void removeChoiceEvent(ChoiceEvent<ITranslatableEnum<?>> event) {
        if (this.choiceEvents != null) {
            this.choiceEvents.remove(event);
        }
    }

    private void fireChoiceEvents(String choice) {
        this.fireChannelEvents(TypedMap.builder().put(Window.PARAM_ID, (Object)"choice").put(PARAM_CHOICE, (Object)choice).put(PARAM_CHOICE_IDX, (Object)ArrayUtils.indexOf((Object[])this.choices, (Object)Arrays.stream(this.choices).filter(item -> item.getID().equals(choice)).findAny().get())).build());
        if (this.choiceEvents != null) {
            for (ChoiceEvent<String> event : this.choiceEvents) {
                event.choiceChanged((Object)choice);
            }
        }
    }

    public void readFromGuiCommand(GuiParser.GuiCommand command) {
        super.readFromGuiCommand(command);
        command.findCommand("choices").ifPresent(cmd -> cmd.commands().forEach(choiceCmd -> {
            Integer enumIndex = (Integer)choiceCmd.getOptionalPar(0, (Object)0);
            choiceCmd.findCommand("tooltips").ifPresent(tooltipsCmd -> this.tooltipMap.put(this.choices[enumIndex], tooltipsCmd.parameters().map(Object::toString).collect(Collectors.toList())));
        }));
    }

    public void fillGuiCommand(GuiParser.GuiCommand command) {
        super.fillGuiCommand(command);
        command.removeParameter(1);
        GuiParser.GuiCommand choicesCmd = new GuiParser.GuiCommand("choices");
        for (IChannelType s : this.choices) {
            GuiParser.GuiCommand choiceCmd = new GuiParser.GuiCommand("choice").parameter((Object)s.getID());
            choicesCmd.command(choiceCmd);
            List<String> tooltips = this.tooltipMap.get(s);
            if (tooltips == null || tooltips.isEmpty()) continue;
            GuiParser.GuiCommand tooltipsCmd = new GuiParser.GuiCommand("tooltips");
            choiceCmd.command(tooltipsCmd);
            for (String tt : tooltips) {
                tooltipsCmd.parameter((Object)tt);
            }
        }
        command.command(choicesCmd);
    }

    public GuiParser.GuiCommand createGuiCommand() {
        return new GuiParser.GuiCommand(TYPE_CHANNEL_CHOICE_LABEL);
    }
}

