/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.wireless;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.datagen.Dob;
import mcjty.lib.modules.IModule;
import mcjty.lib.setup.DeferredBlock;
import mcjty.lib.setup.DeferredItem;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.xnet.XNet;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.wireless.blocks.TileEntityWirelessRouter;
import mcjty.xnet.modules.wireless.client.GuiWirelessRouter;
import mcjty.xnet.setup.Config;
import mcjty.xnet.setup.Registration;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class WirelessRouterModule
implements IModule {
    public static final DeferredBlock<BaseBlock> WIRELESS_ROUTER = Registration.BLOCKS.register("wireless_router", TileEntityWirelessRouter::createBlock);
    public static final DeferredItem<Item> WIRELESS_ROUTER_ITEM = Registration.ITEMS.register("wireless_router", XNet.tab(() -> new BlockItem(WIRELESS_ROUTER.get(), Registration.createStandardProperties())));
    public static final Supplier<BlockEntityType<?>> TYPE_WIRELESS_ROUTER = Registration.TILES.register("wireless_router", () -> BlockEntityType.Builder.m_155273_(TileEntityWirelessRouter::new, (Block[])new Block[]{WIRELESS_ROUTER.get()}).m_58966_(null));
    public static final Supplier<MenuType<GenericContainer>> CONTAINER_WIRELESS_ROUTER = Registration.CONTAINERS.register("wireless_router", GenericContainer::createContainerType);
    public static final DeferredBlock<BaseBlock> ANTENNA = Registration.BLOCKS.register("antenna", WirelessRouterModule::createAntennaBlock);
    public static final DeferredItem<Item> ANTENNA_ITEM = Registration.ITEMS.register("antenna", XNet.tab(() -> new BlockItem(ANTENNA.get(), Registration.createStandardProperties())));
    public static final DeferredBlock<BaseBlock> ANTENNA_BASE = Registration.BLOCKS.register("antenna_base", WirelessRouterModule::createAntennaBaseBlock);
    public static final DeferredItem<Item> ANTENNA_BASE_ITEM = Registration.ITEMS.register("antenna_base", XNet.tab(() -> new BlockItem(ANTENNA_BASE.get(), Registration.createStandardProperties())));
    public static final DeferredBlock<BaseBlock> ANTENNA_DISH = Registration.BLOCKS.register("antenna_dish", WirelessRouterModule::createAntennaDishBlock);
    public static final DeferredItem<Item> ANTENNA_DISH_ITEM = Registration.ITEMS.register("antenna_dish", XNet.tab(() -> new BlockItem(ANTENNA_DISH.get(), Registration.createStandardProperties())));
    public static final VoxelShape SMALLER_CUBE = Shapes.m_83048_((double)0.01f, (double)0.01f, (double)0.01f, (double)0.99f, (double)0.99f, (double)0.99f);

    private static BaseBlock createAntennaDishBlock() {
        return new BaseBlock(new BlockBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"info", stack -> Integer.toString((Integer)Config.wirelessRouterRfPerChannel[2].get()) + " rf/t/channel")})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }

            @Nonnull
            public VoxelShape m_7952_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
                return SMALLER_CUBE;
            }
        };
    }

    private static BaseBlock createAntennaBaseBlock() {
        return new BaseBlock(new BlockBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }

            @Nonnull
            public VoxelShape m_7952_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
                return SMALLER_CUBE;
            }
        };
    }

    private static BaseBlock createAntennaBlock() {
        return new BaseBlock(new BlockBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"one", stack -> "range " + Integer.toString((Integer)Config.antennaTier1Range.get()) + " (" + Integer.toString((Integer)Config.wirelessRouterRfPerChannel[0].get()) + " rf/t/channel)"), TooltipBuilder.parameter((String)"two", stack -> "range " + Integer.toString((Integer)Config.antennaTier2Range.get()) + " (" + Integer.toString((Integer)Config.wirelessRouterRfPerChannel[1].get()) + " rf/t/channel)")})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }

            @Nonnull
            public VoxelShape m_7952_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
                return SMALLER_CUBE;
            }
        };
    }

    public void init(FMLCommonSetupEvent event) {
    }

    public void initClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> GuiWirelessRouter.register());
    }

    public void initConfig(IEventBus bus) {
    }

    public void initDatagen(DataGen dataGen) {
        dataGen.add(new Dob.Builder[]{Dob.blockBuilder(WIRELESS_ROUTER).ironPickaxeTags().parentedItem("block/wireless_router").standardLoot(TYPE_WIRELESS_ROUTER).blockState(p -> {
            ModelFile modelOk = p.frontBasedModel("wireless_router", p.modLoc("block/machine_wireless_router"));
            ModelFile modelError = p.frontBasedModel("wireless_router_error", p.modLoc("block/machine_wireless_router_error"));
            VariantBlockStateBuilder builder = p.getVariantBuilder(WIRELESS_ROUTER.get());
            for (Direction direction : OrientationTools.DIRECTION_VALUES) {
                p.applyRotation(builder.partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)direction).with((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(modelOk), direction);
                p.applyRotation(builder.partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)direction).with((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(modelError), direction);
            }
        }).shaped(builder -> builder.m_126127_(Character.valueOf('F'), (ItemLike)VariousModule.MACHINE_FRAME.get()).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42351_).m_126132_("frame", (CriterionTriggerInstance)DataGen.has((ItemLike)VariousModule.MACHINE_FRAME.get())), new String[]{"oCo", "rFr", "oro"}), Dob.blockBuilder(ANTENNA).simpleLoot().ironPickaxeTags().shaped(builder -> builder.m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42025_).m_126132_("bars", (CriterionTriggerInstance)DataGen.has((ItemLike)Items.f_42025_)), new String[]{"IiI", "IiI", " i "}), Dob.blockBuilder(ANTENNA_BASE).simpleLoot().ironPickaxeTags().shaped(builder -> builder.m_126127_(Character.valueOf('I'), (ItemLike)Items.f_41913_).m_126132_("block", (CriterionTriggerInstance)DataGen.has((ItemLike)Items.f_41913_)), new String[]{" i ", " i ", "iIi"}), Dob.blockBuilder(ANTENNA_DISH).simpleLoot().ironPickaxeTags().shaped(builder -> builder.m_126127_(Character.valueOf('I'), (ItemLike)Items.f_42128_).m_126132_("trapdoor", (CriterionTriggerInstance)DataGen.has((ItemLike)Items.f_42128_)), new String[]{"III", "IoI", " i "})});
    }
}

