/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.items;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mcjty.xnet.apiimpl.Constants;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.enums.InsExtMode;
import mcjty.xnet.apiimpl.items.ItemFilterCache;
import mcjty.xnet.apiimpl.items.enums.ExtractMode;
import mcjty.xnet.apiimpl.items.enums.StackMode;
import mcjty.xnet.utils.CastTools;
import mcjty.xnet.utils.I18nConstants;
import mcjty.xnet.utils.TagUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemConnectorSettings
extends AbstractConnectorSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    public static final int FILTER_SIZE = 18;
    private InsExtMode itemMode = InsExtMode.INS;
    private ExtractMode extractMode = ExtractMode.FIRST;
    private int speed = 2;
    private StackMode stackMode = StackMode.SINGLE;
    private boolean tagsMode = false;
    private boolean metaMode = false;
    private boolean nbtMode = false;
    private boolean blacklist = false;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer count = null;
    @Nullable
    private Integer extractAmount = null;
    private final ItemStackList filters = ItemStackList.create((int)18);
    private int filterIndex = -1;
    private Predicate<ItemStack> matcher = null;
    private static final Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"count", "priority", "od", "meta", "nbt", "blacklist"});
    private static final Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"count", "od", "meta", "nbt", "blacklist", "stack", "speed", "extract", "extractAmount"});

    public InsExtMode getItemMode() {
        return this.itemMode;
    }

    public ItemConnectorSettings(@Nonnull Direction side) {
        super(side);
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return switch (this.itemMode) {
            default -> throw new IncompatibleClassChangeError();
            case InsExtMode.INS -> new IndicatorIcon(iconGuiElements, 0, 70, 13, 10);
            case InsExtMode.EXT -> new IndicatorIcon(iconGuiElements, 13, 70, 13, 10);
        };
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    private String getMinMaxTooltip() {
        return I18nConstants.ITEM_COUNT_TOOLTIP_FORMATTED.i18n((this.itemMode == InsExtMode.EXT ? I18nConstants.EXT_ENDING : I18nConstants.INS_ENDING).i18n(new Object[0]), (this.itemMode == InsExtMode.EXT ? I18nConstants.LOW_FORMAT : I18nConstants.HIGH_FORMAT).i18n(new Object[0]));
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        String[] speeds = this.advanced ? Constants.ADVANCED_SPEEDS : Constants.SPEEDS;
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl();
        gui.translatableChoices("mode", (ITranslatableEnum)this.itemMode, (ITranslatableEnum[])InsExtMode.values()).shift(5);
        gui.translatableChoices("stack", (ITranslatableEnum)this.stackMode, (ITranslatableEnum[])StackMode.values());
        if (this.stackMode == StackMode.COUNT && this.itemMode == InsExtMode.EXT) {
            gui.integer("extractAmount", I18nConstants.ITEM_EXT_COUNT_TOOLTIP.i18n(new Object[0]), this.extractAmount, 30, Integer.valueOf(64));
        }
        gui.shift(10).choices("speed", I18nConstants.SPEED_TOOLTIP.i18n(new Object[0]), Integer.toString(this.speed * 5), speeds);
        gui.nl();
        gui.label(I18nConstants.PRIORITY_LABEL.i18n(new Object[0])).integer("priority", I18nConstants.PRIORITY_TOOLTIP.i18n(new Object[0]), this.priority, 36).shift(5).label("#").integer("count", this.getMinMaxTooltip(), this.count, 30);
        if (this.itemMode == InsExtMode.EXT) {
            gui.shift(5).translatableChoices("extract", (ITranslatableEnum)this.extractMode, (ITranslatableEnum[])ExtractMode.values());
        }
        gui.nl();
        gui.toggleText("blacklist", I18nConstants.ITEM_BLACKLIST_TOOLTIP.i18n(new Object[0]), I18nConstants.ITEM_BLACKLIST_LABEL.i18n(new Object[0]), this.blacklist).shift(0).toggleText("od", I18nConstants.ITEM_TAGS_TOOLTIP.i18n(new Object[0]), I18nConstants.ITEM_TAGS_LABEL.i18n(new Object[0]), this.tagsMode).shift(0).toggleText("meta", I18nConstants.ITEM_META_TOOLTIP.i18n(new Object[0]), I18nConstants.ITEM_META_LABEL.i18n(new Object[0]), this.metaMode).shift(0).toggleText("nbt", I18nConstants.ITEM_NBT_TOOLTIP.i18n(new Object[0]), I18nConstants.ITEM_NBT_LABEL.i18n(new Object[0]), this.nbtMode).shift(0).choices("fltIdx", I18nConstants.ITEM_FILTER_INDEX_TOOLTIP.i18n(new Object[0]), this.getFilterIndexString(), new String[]{I18nConstants.ITEM_FILTER_OFF.i18n(new Object[0]), "1", "2", "3", "4"}).nl();
        for (int i = 0; i < 18; ++i) {
            if (i > 0 && i % 9 == 0) {
                gui.nl();
            }
            gui.ghostSlot("flt" + i, (ItemStack)this.filters.get(i));
        }
    }

    private String getFilterIndexString() {
        if (this.filterIndex == -1) {
            return I18nConstants.ITEM_FILTER_OFF.i18n(new Object[0]);
        }
        return Integer.toString(this.filterIndex);
    }

    public Predicate<ItemStack> getMatcher(IControllerContext context) {
        if (this.matcher == null) {
            ItemStackList filterList = ItemStackList.create();
            for (ItemStack stack2 : this.filters) {
                if (stack2.m_41619_()) continue;
                filterList.add((Object)stack2);
            }
            Predicate<ItemStack> filterMatcher = this.getIndexFilterMatcher(context);
            if (filterList.isEmpty()) {
                this.matcher = filterMatcher != null ? filterMatcher : itemStack -> true;
            } else {
                ItemFilterCache filterCache = new ItemFilterCache(this.metaMode, this.tagsMode, this.blacklist, this.nbtMode, filterList);
                this.matcher = filterMatcher != null ? stack -> filterMatcher.test((ItemStack)stack) || filterCache.match((ItemStack)stack) : filterCache::match;
            }
        }
        return this.matcher;
    }

    @Nullable
    private Predicate<ItemStack> getIndexFilterMatcher(IControllerContext context) {
        if (this.filterIndex == -1) {
            return null;
        }
        return s -> context.getIndexedFilter(this.filterIndex - 1).test(s);
    }

    public StackMode getStackMode() {
        return this.stackMode;
    }

    public ExtractMode getExtractMode() {
        return this.extractMode;
    }

    @Nonnull
    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nullable
    public Integer getCount() {
        return this.count;
    }

    public int getExtractAmount() {
        return this.extractAmount == null ? 1 : this.extractAmount;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public boolean isEnabled(String tag) {
        if (tag.startsWith("flt")) {
            return true;
        }
        if (tag.equals("facing")) {
            return this.advanced;
        }
        if (this.itemMode == InsExtMode.INS) {
            return INSERT_TAGS.contains(tag);
        }
        return EXTRACT_TAGS.contains(tag);
    }

    public void setSpeed(int speed) {
        this.speed = speed != 0 ? speed : 4;
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.itemMode = CastTools.safeInsExtMode(data.get("mode"));
        this.extractMode = CastTools.safeExtractMode(data.get("extract"));
        this.stackMode = CastTools.safeStackMode(data.get("stack"));
        this.setSpeed(Integer.parseInt((String)data.get("speed")) / 5);
        String idx = (String)data.get("fltIdx");
        this.filterIndex = CastTools.safeIntOrValue(idx, -1);
        this.tagsMode = Boolean.TRUE.equals(data.get("od"));
        this.metaMode = Boolean.TRUE.equals(data.get("meta"));
        this.nbtMode = Boolean.TRUE.equals(data.get("nbt"));
        this.blacklist = Boolean.TRUE.equals(data.get("blacklist"));
        this.priority = (Integer)data.get("priority");
        this.count = (Integer)data.get("count");
        this.extractAmount = (Integer)data.get("extractAmount");
        for (int i = 0; i < 18; ++i) {
            this.filters.set(i, (Object)((ItemStack)data.get("flt" + i)));
        }
        this.matcher = null;
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        ItemConnectorSettings.setEnumSafe((JsonObject)object, (String)"itemMode", (Enum)this.itemMode);
        ItemConnectorSettings.setEnumSafe((JsonObject)object, (String)"extractMode", (Enum)this.extractMode);
        ItemConnectorSettings.setEnumSafe((JsonObject)object, (String)"stackMode", (Enum)this.stackMode);
        object.add("tagsMode", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.tagsMode)));
        object.add("metaMode", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.metaMode)));
        object.add("nbtMode", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.nbtMode)));
        object.add("blacklist", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.blacklist)));
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)"priority", (Integer)this.priority);
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)"extractAmount", (Integer)this.extractAmount);
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)"count", (Integer)this.count);
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)"speed", (Integer)this.speed);
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)"filterindex", (Integer)this.filterIndex);
        for (int i = 0; i < 18; ++i) {
            if (((ItemStack)this.filters.get(i)).m_41619_()) continue;
            object.add("flt" + i, (JsonElement)JSonTools.itemStackToJson((ItemStack)((ItemStack)this.filters.get(i))));
        }
        if (this.speed == 1) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.itemMode = (InsExtMode)ItemConnectorSettings.getEnumSafe((JsonObject)object, (String)"itemMode", EnumStringTranslators::getItemMode);
        this.extractMode = (ExtractMode)ItemConnectorSettings.getEnumSafe((JsonObject)object, (String)"extractMode", EnumStringTranslators::getExtractMode);
        this.stackMode = (StackMode)ItemConnectorSettings.getEnumSafe((JsonObject)object, (String)"stackMode", EnumStringTranslators::getStackMode);
        this.tagsMode = ItemConnectorSettings.getBoolSafe((JsonObject)object, (String)"tagsMode");
        this.metaMode = ItemConnectorSettings.getBoolSafe((JsonObject)object, (String)"metaMode");
        this.nbtMode = ItemConnectorSettings.getBoolSafe((JsonObject)object, (String)"nbtMode");
        this.blacklist = ItemConnectorSettings.getBoolSafe((JsonObject)object, (String)"blacklist");
        this.priority = ItemConnectorSettings.getIntegerSafe((JsonObject)object, (String)"priority");
        this.extractAmount = ItemConnectorSettings.getIntegerSafe((JsonObject)object, (String)"extractAmount");
        this.count = ItemConnectorSettings.getIntegerSafe((JsonObject)object, (String)"count");
        this.speed = ItemConnectorSettings.getIntegerNotNull((JsonObject)object, (String)"speed");
        this.filterIndex = object.has("filterindex") ? ItemConnectorSettings.getIntegerNotNull((JsonObject)object, (String)"filterindex") : -1;
        for (int i = 0; i < 18; ++i) {
            if (object.has("flt" + i)) {
                this.filters.set(i, (Object)JSonTools.jsonToItemStack((JsonObject)object.get("flt" + i).getAsJsonObject()));
                continue;
            }
            this.filters.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.itemMode = InsExtMode.values()[tag.m_128445_("itemMode")];
        this.extractMode = ExtractMode.values()[tag.m_128445_("extractMode")];
        this.stackMode = StackMode.values()[tag.m_128445_("stackMode")];
        if (tag.m_128441_("speed")) {
            this.setSpeed(tag.m_128451_("speed"));
        } else {
            this.setSpeed(tag.m_128451_("spd"));
        }
        this.filterIndex = tag.m_128441_("filterindex") ? tag.m_128451_("filterindex") : -1;
        this.tagsMode = tag.m_128471_("tagsMode");
        this.metaMode = tag.m_128471_("metaMode");
        this.nbtMode = tag.m_128471_("nbtMode");
        this.blacklist = tag.m_128471_("blacklist");
        this.priority = TagUtils.getIntOrNull(tag, "priority");
        this.extractAmount = TagUtils.getIntOrNull(tag, "extractAmount");
        this.count = TagUtils.getIntOrNull(tag, "count");
        for (int i = 0; i < 18; ++i) {
            if (tag.m_128441_("flt" + i)) {
                CompoundTag itemTag = tag.m_128469_("flt" + i);
                this.filters.set(i, (Object)ItemStack.m_41712_((CompoundTag)itemTag));
                continue;
            }
            this.filters.set(i, (Object)ItemStack.f_41583_);
        }
        this.matcher = null;
    }

    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128344_("itemMode", (byte)this.itemMode.ordinal());
        tag.m_128344_("extractMode", (byte)this.extractMode.ordinal());
        tag.m_128344_("stackMode", (byte)this.stackMode.ordinal());
        tag.m_128405_("speed", this.speed);
        tag.m_128405_("filterindex", this.filterIndex);
        tag.m_128379_("tagsMode", this.tagsMode);
        tag.m_128379_("metaMode", this.metaMode);
        tag.m_128379_("nbtMode", this.nbtMode);
        tag.m_128379_("blacklist", this.blacklist);
        TagUtils.putIntIfNotNull(tag, "priority", this.priority);
        TagUtils.putIntIfNotNull(tag, "extractAmount", this.extractAmount);
        TagUtils.putIntIfNotNull(tag, "count", this.count);
        for (int i = 0; i < 18; ++i) {
            if (((ItemStack)this.filters.get(i)).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            ((ItemStack)this.filters.get(i)).m_41739_(itemTag);
            tag.m_128365_("flt" + i, (Tag)itemTag);
        }
    }
}

