/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.registry;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModItems;

public final class ModPotions {
    public static Potion spectral = (Potion)Helper.unsafeNullCast();
    public static Potion earthly_garden = (Potion)Helper.unsafeNullCast();
    public static Potion bait = (Potion)Helper.unsafeNullCast();
    public static Potion frostbite = (Potion)Helper.unsafeNullCast();
    public static Potion darkness = (Potion)Helper.unsafeNullCast();
    public static Potion discretion = (Potion)Helper.unsafeNullCast();
    public static Potion restoration = (Potion)Helper.unsafeNullCast();

    static void onRegister(RegisterEvent event) {
        spectral = ModPotions.registerPotion(event, new Potion(new MobEffectInstance[0]), "spectral");
        earthly_garden = ModPotions.registerPotion(event, ModEffects.earthly_garden, "earthly_garden");
        bait = ModPotions.registerPotion(event, ModEffects.bait, "bait");
        frostbite = ModPotions.registerPotion(event, ModEffects.frostbite, "frostbite");
        darkness = ModPotions.registerPotion(event, MobEffects.f_216964_, "darkness");
        discretion = ModPotions.registerPotion(event, ModEffects.discretion, "discretion");
        restoration = ModPotions.registerPotion(event, ModEffects.restoration, "restoration");
        BrewingRecipeRegistry.addRecipe((Ingredient)StrictNBTIngredient.of((ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_)), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.grave_dust}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)spectral));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(spectral, Items.f_220221_, earthly_garden, () -> SharedConfigTombstone.potions.allowEarthlyGarden.get()));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(spectral, Items.f_220220_, bait, () -> SharedConfigTombstone.potions.allowBait.get()));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(spectral, Items.f_42363_, frostbite, () -> SharedConfigTombstone.potions.allowFrostbite.get()));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(spectral, Items.f_220224_, darkness, () -> SharedConfigTombstone.potions.allowDarkness.get()));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(spectral, Items.f_42714_, discretion, () -> SharedConfigTombstone.potions.allowDiscretion.get()));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ConfigurableBrewingRecipe(Potions.f_43581_, ModItems.grave_dust, restoration, () -> SharedConfigTombstone.potions.allowRestoration.get()));
    }

    private static Potion registerPotion(RegisterEvent event, MobEffect effect, String name) {
        return ModPotions.registerPotion(event, new Potion(new MobEffectInstance[]{new MobEffectInstance(effect, effect.m_8093_() ? 1 : 9600, 4)}), name);
    }

    private static Potion registerPotion(RegisterEvent event, Potion potion, String name) {
        event.register(ForgeRegistries.Keys.POTIONS, new ResourceLocation("tombstone", name), () -> potion);
        return potion;
    }

    public static class ConfigurableBrewingRecipe
    implements IBrewingRecipe {
        private final ItemStack input;
        private final Item ingredient;
        private final ItemStack output;
        private final BooleanSupplier supplierEnabled;

        public ConfigurableBrewingRecipe(Potion input, Item ingredient, Potion output, BooleanSupplier supplierEnabled) {
            this.input = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)input);
            this.ingredient = ingredient;
            this.output = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)output);
            this.supplierEnabled = supplierEnabled;
        }

        public boolean isInput(ItemStack input) {
            return this.supplierEnabled.getAsBoolean() && this.input.m_150930_(input.m_41720_()) && Objects.equals(PotionUtils.m_43579_((ItemStack)this.input), PotionUtils.m_43579_((ItemStack)input));
        }

        public boolean isIngredient(ItemStack stack) {
            return this.supplierEnabled.getAsBoolean() && stack.m_150930_(this.ingredient);
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            return this.supplierEnabled.getAsBoolean() && this.isInput(input) && this.isIngredient(ingredient) ? this.getOutput().m_41777_() : ItemStack.f_41583_;
        }

        private ItemStack getOutput() {
            return this.output;
        }
    }
}

