/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;

public final class SupportStructures
extends Enum<SupportStructures> {
    public static final /* enum */ SupportStructures VILLAGE = new SupportStructures("village", (TagKey<Structure>)StructureTags.f_215889_);
    public static final /* enum */ SupportStructures DESERT_PYRAMID = new SupportStructures("desert_pyramid", (ResourceKey<Structure>)BuiltinStructures.f_209850_);
    public static final /* enum */ SupportStructures IGLOO = new SupportStructures("igloo", (ResourceKey<Structure>)BuiltinStructures.f_209851_);
    public static final /* enum */ SupportStructures JUNGLE_TEMPLE = new SupportStructures("jungle_pyramid", (ResourceKey<Structure>)BuiltinStructures.f_209849_);
    public static final /* enum */ SupportStructures MANSION = new SupportStructures("mansion", (ResourceKey<Structure>)BuiltinStructures.f_209848_);
    public static final /* enum */ SupportStructures MONUMENT = new SupportStructures("monument", (ResourceKey<Structure>)BuiltinStructures.f_209856_);
    public static final /* enum */ SupportStructures STRONGHOLD = new SupportStructures("stronghold", (ResourceKey<Structure>)BuiltinStructures.f_209855_, 35);
    public static final /* enum */ SupportStructures END_CITY = new SupportStructures("end_city", (ResourceKey<Structure>)BuiltinStructures.f_209861_);
    public static final /* enum */ SupportStructures MINESHAFT = new SupportStructures("mineshaft", (TagKey<Structure>)StructureTags.f_215890_, 37);
    public static final /* enum */ SupportStructures FORTRESS = new SupportStructures("fortress", (ResourceKey<Structure>)BuiltinStructures.f_209859_, 35);
    public static final /* enum */ SupportStructures SWAMP_HUT = new SupportStructures("swamp_hut", (ResourceKey<Structure>)BuiltinStructures.f_209854_);
    public static final /* enum */ SupportStructures OCEAN_RUIN = new SupportStructures("ocean_ruin", (TagKey<Structure>)StructureTags.f_215893_);
    public static final /* enum */ SupportStructures BURIED_TREASURE = new SupportStructures("buried_treasure", (ResourceKey<Structure>)BuiltinStructures.f_209862_);
    public static final /* enum */ SupportStructures SHIPWRECK = new SupportStructures("shipwreck", (TagKey<Structure>)StructureTags.f_215891_);
    public static final /* enum */ SupportStructures PILLAGER_OUTPOST = new SupportStructures("pillager_outpost", (ResourceKey<Structure>)BuiltinStructures.f_209845_);
    public static final /* enum */ SupportStructures RUINED_PORTAL = new SupportStructures("ruined_portal", (TagKey<Structure>)StructureTags.f_215892_);
    public static final /* enum */ SupportStructures NETHER_FOSSIL = new SupportStructures("nether_fossil", (ResourceKey<Structure>)BuiltinStructures.f_209860_);
    public static final /* enum */ SupportStructures BASTION_REMNANT = new SupportStructures("bastion_remnant", (ResourceKey<Structure>)BuiltinStructures.f_209863_, 35);
    public static final /* enum */ SupportStructures ANCIENT_CITY = new SupportStructures("ancient_city", (ResourceKey<Structure>)BuiltinStructures.f_226492_);
    public static final /* enum */ SupportStructures TRAIL_RUINS = new SupportStructures("trail_ruins", (ResourceKey<Structure>)BuiltinStructures.f_276588_);
    private static final Map<ResourceKey<Level>, Object2BooleanMap<ResourceLocation>> STRUCTURES_BY_WORLD;
    private static final Map<String, Component> STRUCTURE_NAMES;
    public static final int DEFAULT_Y = 68;
    private final String identifier;
    @Nullable
    private TagKey<Structure> tagKey = null;
    @Nullable
    private ResourceKey<Structure> resourceKey = null;
    private final int y;
    private static final /* synthetic */ SupportStructures[] $VALUES;

    public static SupportStructures[] values() {
        return (SupportStructures[])$VALUES.clone();
    }

    public static SupportStructures valueOf(String name) {
        return Enum.valueOf(SupportStructures.class, name);
    }

    private SupportStructures(String identifier, ResourceKey<Structure> tagKey) {
        this(identifier, tagKey, 68);
    }

    private SupportStructures(String identifier, ResourceKey<Structure> resourceKey, int y) {
        this.identifier = identifier;
        this.resourceKey = resourceKey;
        this.y = y;
    }

    private SupportStructures(String structureName, TagKey<Structure> tagKey) {
        this(structureName, tagKey, 68);
    }

    private SupportStructures(String identifier, TagKey<Structure> tagKey, int y) {
        this.identifier = identifier;
        this.tagKey = tagKey;
        this.y = y;
    }

    public String getName() {
        return this.identifier;
    }

    public boolean is(String structureId) {
        Pair<String, String> rl = Helper.parseRLString(structureId);
        return this.is((String)rl.getLeft(), (String)rl.getRight());
    }

    public boolean is(ResourceLocation structureId) {
        return this.is(structureId.m_135827_(), structureId.m_135815_());
    }

    public boolean is(String domain, String path) {
        return SupportStructures.isVanillaDomain(domain) && path.contains(this.getName());
    }

    public int getY() {
        return this.y;
    }

    public HolderSet<Structure> asHolderSet(ServerLevel level) {
        if (this.tagKey != null) {
            return (HolderSet)Helper.asHolderSet(level, this.tagKey).get();
        }
        assert (this.resourceKey != null);
        HolderSet<Structure> res = Helper.asHolderSet(level, this.resourceKey);
        assert (res != null);
        return res;
    }

    private static boolean isVanillaDomain(String domain) {
        return "minecraft".equals(domain);
    }

    @Nullable
    private static SupportStructures getVanillaStructure(String domain, String path) {
        return SupportStructures.isVanillaDomain(domain) ? (SupportStructures)Stream.of(SupportStructures.values()).filter(p -> p.is(path)).findFirst().orElse(null) : null;
    }

    public static int getY(ResourceLocation structureRL) {
        return SupportStructures.getY(structureRL.m_135827_(), structureRL.m_135815_());
    }

    public static int getY(String structureRLString) {
        Pair<String, String> rl = Helper.parseRLString(structureRLString);
        return SupportStructures.getY((String)rl.getLeft(), (String)rl.getRight());
    }

    public static int getY(String domain, String path) {
        SupportStructures struct = SupportStructures.getVanillaStructure(domain, path);
        return struct != null ? struct.getY() : (domain.equals("quark") ? 37 : 68);
    }

    @Nullable
    public static HolderSet<Structure> getRandomVanillaStructure(ServerLevel level, Predicate<SupportStructures> predic) {
        return Helper.getRandomInList(Arrays.stream(SupportStructures.values()).filter(predic).collect(Collectors.toList())).map(supportStructures -> supportStructures.asHolderSet(level)).orElse(null);
    }

    @Nullable
    public static HolderSet<Structure> getRandomStructure(ServerLevel level, Predicate<ResourceLocation> predic) {
        ResourceLocation resourceLocation = Helper.getRandomInList(level.m_9598_().m_175515_(Registries.f_256944_).m_6566_().stream().filter(predic).collect(Collectors.toList())).orElse(null);
        if (resourceLocation != null) {
            SupportStructures supportStructures;
            if (SupportStructures.isVanillaDomain(resourceLocation.m_135827_()) && (supportStructures = (SupportStructures)Arrays.stream(SupportStructures.values()).filter(struct -> struct.is(resourceLocation)).findFirst().orElse(null)) != null) {
                return supportStructures.asHolderSet(level);
            }
            return Helper.asHolderSet(level, resourceLocation);
        }
        return null;
    }

    public static void clear() {
        STRUCTURES_BY_WORLD.clear();
        STRUCTURE_NAMES.clear();
    }

    public static boolean hasStructureInWorld(ServerLevel level, ResourceLocation structureRL, HolderSet<Biome> structureBiomes) {
        return STRUCTURES_BY_WORLD.computeIfAbsent((ResourceKey<Level>)level.m_46472_(), levelKey -> new Object2BooleanOpenHashMap()).computeIfAbsent((Object)structureRL, rl -> {
            Set possibleBiomes = level.m_7726_().m_8481_().m_62218_().m_207840_();
            return structureBiomes.m_203614_().anyMatch(possibleBiomes::contains);
        });
    }

    public static List<ServerLevel> getPossibleWorlds(MinecraftServer server, ResourceLocation structureRL, HolderSet<Biome> structureBiomes) {
        Predicate<ServerLevel> predic = world -> true;
        if (SupportMods.CHUNKBYCHUNK.isLoaded()) {
            predic = world -> {
                ResourceLocation rl = world.m_46472_().m_135782_();
                return !rl.m_135827_().equals("chunkbychunk") && !rl.m_135827_().equals("overworld") && (!rl.m_135815_().startsWith("overworld_") || !rl.m_135815_().endsWith("_gen"));
            };
        }
        if (!((List)ConfigTombstone.magic_item.lostTabletDeniedWorlds.get()).isEmpty()) {
            predic = world -> {
                ResourceLocation rl = world.m_46472_().m_135782_();
                return !Helper.containRL((List<String>)((List)ConfigTombstone.magic_item.lostTabletDeniedWorlds.get()), rl);
            };
        }
        return StreamSupport.stream(server.m_129785_().spliterator(), false).filter(predic).filter(level -> SupportStructures.hasStructureInWorld(level, structureRL, structureBiomes)).collect(Collectors.toList());
    }

    public static Component getStructureName(String structureId) {
        return STRUCTURE_NAMES.computeIfAbsent(structureId, k -> {
            String[] splits = structureId.toLowerCase(Locale.US).split(":");
            MutableComponent structureName = Component.m_237113_((String)Helper.capitalizeWord(splits[splits.length - 1]));
            return splits.length < 2 || SupportStructures.isVanillaDomain(splits[0]) ? structureName : structureName.m_130946_(" [").m_130946_(splits[0]).m_130946_("]");
        });
    }

    private static /* synthetic */ SupportStructures[] $values() {
        return new SupportStructures[]{VILLAGE, DESERT_PYRAMID, IGLOO, JUNGLE_TEMPLE, MANSION, MONUMENT, STRONGHOLD, END_CITY, MINESHAFT, FORTRESS, SWAMP_HUT, OCEAN_RUIN, BURIED_TREASURE, SHIPWRECK, PILLAGER_OUTPOST, RUINED_PORTAL, NETHER_FOSSIL, BASTION_REMNANT, ANCIENT_CITY, TRAIL_RUINS};
    }

    static {
        $VALUES = SupportStructures.$values();
        STRUCTURES_BY_WORLD = new ConcurrentHashMap<ResourceKey<Level>, Object2BooleanMap<ResourceLocation>>();
        STRUCTURE_NAMES = new ConcurrentHashMap<String, Component>();
    }
}

