/*
 * Decompiled with CFR 0.152.
 */
package com.haoict.tiab.common.items;

import com.haoict.tiab.common.config.TiabConfig;
import com.haoict.tiab.common.core.api.APIRegistry;
import com.haoict.tiab.common.core.api.interfaces.ITimeInABottleItemAPI;
import com.haoict.tiab.common.items.AbstractTiabItem;
import com.haoict.tiab.common.utils.Utils;
import com.magorage.tiab.api.ITimeInABottleAPI;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public final class TimeInABottleItem
extends AbstractTiabItem {
    private static ITimeInABottleAPI API;

    public static void setAPI(ITimeInABottleAPI api) {
        if (API != null) {
            return;
        }
        API = api;
    }

    public TimeInABottleItem() {
        class Provider
        implements ITimeInABottleItemAPI {
            final TimeInABottleItem item;

            private Provider(TimeInABottleItem item) {
                this.item = item;
            }

            @Override
            public int getStoredEnergy(ItemStack stack) {
                return this.item.getStoredEnergy(stack);
            }

            @Override
            public void setStoredEnergy(ItemStack stack, int energy) {
                this.item.setStoredEnergy(stack, energy);
            }

            @Override
            public void applyDamage(ItemStack stack, int damage) {
                this.item.applyDamage(stack, damage);
            }

            @Override
            public int getTotalAccumulatedTime(ItemStack stack) {
                return this.item.getTotalAccumulatedTime(stack);
            }

            @Override
            public void setTotalAccumulatedTime(ItemStack stack, int value) {
                this.item.setTotalAccumulatedTime(stack, value);
            }

            @Override
            public int getEnergyCost(int timeRate) {
                return this.item.getEnergyCost(timeRate);
            }

            @Override
            public void playSound(Level level, BlockPos pos, int nextRate) {
                this.item.playSound(level, pos, nextRate);
            }

            @Override
            public InteractionResult accelerateBlock(ITimeInABottleAPI API, ItemStack stack, Player player, Level level, BlockPos pos) {
                return this.item.accelerateBlock(API, stack, player, level, pos);
            }
        }
        APIRegistry.registerAccess(ITimeInABottleItemAPI.class, new Provider(this));
    }

    public void m_6883_(ItemStack itemStack, Level level, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(itemStack, level, entity, itemSlot, isSelected);
        if (level.f_46443_) {
            return;
        }
        if (API.canUse()) {
            if (level.m_46467_() % 20L == 0L) {
                int totalAccumulatedTime;
                int storedTime = API.getStoredTime(itemStack);
                if (storedTime < (Integer)TiabConfig.COMMON.maxStoredTime.get()) {
                    API.setStoredTime(itemStack, storedTime + 20);
                }
                if ((totalAccumulatedTime = API.getTotalTime(itemStack)) < (Integer)TiabConfig.COMMON.maxStoredTime.get()) {
                    API.setTotalTime(itemStack, totalAccumulatedTime + 20);
                }
            }
            if (level.m_46467_() % 200L == 0L) {
                if (!(entity instanceof Player)) {
                    return;
                }
                Player player = (Player)entity;
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack invStack = player.m_150109_().m_8020_(i);
                    if (invStack.m_41720_() != this || invStack == itemStack) continue;
                    int otherTimeData = API.getStoredTime(invStack);
                    int myTimeData = API.getStoredTime(itemStack);
                    if (myTimeData >= otherTimeData) continue;
                    API.setStoredTime(itemStack, 0);
                }
            }
        } else {
            ServerPlayer player = null;
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer;
                player = serverPlayer = (ServerPlayer)entity;
            }
            API.callTickEvent(player, itemStack);
        }
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(itemStack, world, tooltip, flag);
        tooltip.add(Utils.getStoredTimeTranslated(itemStack));
        tooltip.add(Utils.getTotalTimeTranslated(itemStack));
    }

    @Override
    protected int getStoredEnergy(ItemStack stack) {
        return stack.m_41784_().m_128451_("storedTime");
    }

    @Override
    protected void setStoredEnergy(ItemStack stack, int energy) {
        int newStoredTime = Math.min(energy, (Integer)TiabConfig.COMMON.maxStoredTime.get());
        stack.m_41784_().m_128405_("storedTime", newStoredTime);
    }

    @Override
    protected void applyDamage(ItemStack stack, int damage) {
        this.setStoredEnergy(stack, this.getStoredEnergy(stack) - damage);
    }

    private int getTotalAccumulatedTime(ItemStack stack) {
        return stack.m_41784_().m_128451_("totalAccumulatedTime");
    }

    private void setTotalAccumulatedTime(ItemStack stack, int value) {
        int newValue = Math.min(value, (Integer)TiabConfig.COMMON.maxStoredTime.get());
        stack.m_41784_().m_128405_("totalAccumulatedTime", newValue);
    }
}

