/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.gui.BaseContainer;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.network.IContainerFactory;

public final class BaseContainerType<T extends BaseContainer>
extends MenuType<T> {
    private final BiConsumer<T, FriendlyByteBuf> containerSerializer;
    private final BiFunction<Player, FriendlyByteBuf, T> containerDeserializer;

    public static <T extends BaseContainer> BaseContainerType<T> create(BiConsumer<T, FriendlyByteBuf> containerSerializer, BiFunction<Player, FriendlyByteBuf, T> containerDeserializer) {
        return new BaseContainerType<T>(containerSerializer, containerDeserializer);
    }

    private BaseContainerType(BiConsumer<T, FriendlyByteBuf> containerSerializer, BiFunction<Player, FriendlyByteBuf, T> containerDeserializer) {
        super((MenuType.MenuSupplier)((IContainerFactory)(id, inventory, data) -> {
            BaseContainer container = (BaseContainer)((Object)((Object)containerDeserializer.apply(inventory.f_35978_, data)));
            container.setContainerId(id);
            return container;
        }), FeatureFlagSet.m_246902_());
        this.containerSerializer = containerSerializer;
        this.containerDeserializer = containerDeserializer;
    }

    public void writeContainer(T container, FriendlyByteBuf buffer) {
        this.containerSerializer.accept(container, buffer);
    }
}

