/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.viewer.common;

import com.almostreliable.summoningrituals.platform.Platform;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;

public class MobIngredient {
    private final EntityType<?> mob;
    private final int count;
    private final CompoundTag tag;
    @Nullable
    private Entity entity;

    public MobIngredient(EntityType<?> mob, int count, CompoundTag tag) {
        this.mob = mob;
        this.count = count;
        this.tag = tag;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            this.entity = mob.m_20615_((Level)level);
            if (this.entity != null && !tag.m_128456_()) {
                this.entity.m_20258_(tag);
            }
        }
    }

    public MobIngredient(EntityType<?> mob, int count) {
        this(mob, count, new CompoundTag());
    }

    public Component getDisplayName() {
        if (this.entity == null) {
            return Component.m_237113_((String)"Unknown Entity");
        }
        return this.entity.m_5446_();
    }

    public MutableComponent getRegistryName() {
        return Component.m_237113_((String)Platform.getId(this.mob).toString());
    }

    public EntityType<?> getEntityType() {
        return this.mob;
    }

    public int getCount() {
        return this.count;
    }

    public CompoundTag getTag() {
        return this.tag;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    @Nullable
    public SpawnEggItem getEgg() {
        return SpawnEggItem.m_43213_(this.mob);
    }
}

