/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.viewer.common;

import com.almostreliable.summoningrituals.platform.Platform;
import com.almostreliable.summoningrituals.recipe.component.BlockReference;
import com.almostreliable.summoningrituals.util.TextUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockReferenceRenderer {
    protected final int size;
    private final Minecraft mc;
    private final BlockRenderDispatcher blockRenderer;

    protected BlockReferenceRenderer(int size) {
        this.size = size;
        this.mc = Minecraft.m_91087_();
        this.blockRenderer = this.mc.m_91289_();
    }

    public void render(GuiGraphics guiGraphics, @Nullable BlockReference blockReference) {
        if (blockReference == null) {
            return;
        }
        PoseStack stack = guiGraphics.m_280168_();
        stack.m_85836_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        stack.m_252880_(0.93f * (float)this.size, 0.77f * (float)this.size, 100.0f);
        stack.m_85841_(0.625f * (float)this.size, 0.625f * (float)this.size, 0.625f * (float)this.size);
        stack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
        stack.m_252781_(Axis.f_252495_.m_252977_(30.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
        MultiBufferSource.BufferSource bufferSource = this.mc.m_91269_().m_110104_();
        Platform.renderSingleBlock(this.blockRenderer, blockReference, stack, bufferSource);
        bufferSource.m_109911_();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        stack.m_85849_();
    }

    public List<Component> getTooltip(BlockReference blockReference, TooltipFlag tooltipFlag) {
        BlockState displayState = blockReference.getDisplayState();
        ItemStack stack = new ItemStack((ItemLike)displayState.m_60734_());
        try {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)TextUtils.translate("tooltip", "block_below", ChatFormatting.GOLD).m_130946_(": ").m_7220_((Component)((MutableComponent)stack.m_41786_()).m_130940_(ChatFormatting.WHITE)));
            if (tooltipFlag.m_7050_()) {
                tooltip.add((Component)Component.m_237113_((String)Platform.getId(stack.m_41720_()).toString()).m_130940_(ChatFormatting.DARK_GRAY));
            }
            this.appendStateTooltip(displayState, tooltip);
            return tooltip;
        }
        catch (Exception e) {
            return List.of(Component.m_237113_((String)"Error rendering tooltip!").m_130946_(e.getMessage()).m_130940_(ChatFormatting.DARK_RED));
        }
    }

    private void appendStateTooltip(BlockState displayState, List<Component> tooltip) {
        BlockState defaultState = displayState.m_60734_().m_49966_();
        ArrayList<CallSite> modifiedProps = new ArrayList<CallSite>();
        for (Property property : displayState.m_61147_()) {
            if (displayState.m_61143_(property).equals(defaultState.m_61143_(property))) continue;
            modifiedProps.add((CallSite)((Object)(property.m_61708_() + ": " + displayState.m_61143_(property))));
        }
        if (modifiedProps.isEmpty()) {
            return;
        }
        tooltip.add((Component)TextUtils.translate("tooltip", "properties", ChatFormatting.AQUA).m_7220_((Component)TextUtils.colorize(":", ChatFormatting.AQUA)));
        for (String string : modifiedProps) {
            tooltip.add((Component)TextUtils.colorize("\u00bb ", ChatFormatting.GRAY).m_7220_((Component)TextUtils.colorize(string, ChatFormatting.WHITE)));
        }
    }
}

