/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.altar;

import com.almostreliable.summoningrituals.altar.AltarBlockEntity;
import com.almostreliable.summoningrituals.util.MathUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;

public class AltarRenderer
implements BlockEntityRenderer<AltarBlockEntity> {
    private static final int MAX_RENDER_DISTANCE = 32;
    private static final int MAX_ITEM_HEIGHT = 2;
    private static final int MAX_RESET = 60;
    private static final float MAX_PROGRESS_HEIGHT = 2.5f;
    private static final float HALF = 0.5f;
    private static final float ITEM_OFFSET = 1.5f;
    private final Minecraft mc = Minecraft.m_91087_();
    private final ItemRenderer itemRenderer = this.mc.m_91291_();
    private float resetTimer;
    private double oldCircleOffset;

    public AltarRenderer(BlockEntityRendererProvider.Context ignoredContext) {
    }

    public void render(AltarBlockEntity entity, float partial, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        if (this.mc.f_91074_ == null || entity.m_58904_() == null || entity.m_58899_().m_123331_((Vec3i)this.mc.f_91074_.m_20183_()) > Math.pow(32.0, 2.0)) {
            return;
        }
        stack.m_85836_();
        stack.m_252880_(0.5f, 0.8f, 0.5f);
        stack.m_85841_(0.5f, 0.5f, 0.5f);
        int lightAbove = LevelRenderer.m_109541_((BlockAndTintGetter)entity.m_58904_(), (BlockPos)entity.m_58899_().m_7494_());
        Vec3 altarPos = MathUtils.shiftToCenter(MathUtils.vectorFromPos((Vec3i)entity.m_58899_()));
        Vec3 playerPos = this.mc.f_91074_.m_20182_();
        double playerAngle = Math.toDegrees(Math.atan2(altarPos.f_82479_ - playerPos.f_82479_, playerPos.f_82481_ - altarPos.f_82481_)) + 180.0;
        int progress = entity.getProgress();
        int processTime = entity.getProcessTime();
        stack.m_252880_(0.0f, 2.5f * MathUtils.modifier(progress, processTime, 0.0f), 0.0f);
        if (!entity.getInventory().getCatalyst().m_41619_()) {
            stack.m_85836_();
            stack.m_252880_(0.0f, 1.0f - 0.75f * MathUtils.modifier(progress, processTime, 0.0f), 0.0f);
            stack.m_85841_(0.75f, 0.75f, 0.75f);
            stack.m_252781_(Axis.f_252392_.m_252977_((float)playerAngle));
            this.itemRenderer.m_269128_(entity.getInventory().getCatalyst(), ItemDisplayContext.FIXED, lightAbove, overlay, stack, buffer, entity.m_58904_(), (int)entity.m_58899_().m_121878_());
            stack.m_85849_();
        }
        float axisRotation = MathUtils.singleRotation(entity.m_58904_().m_46467_());
        float scale = 1.0f - MathUtils.modifier(progress, processTime, 0.0f);
        if (progress == 0 && this.resetTimer > 0.0f) {
            scale = 1.0f - MathUtils.modifier(this.resetTimer, 60.0f, 0.0f);
            this.resetTimer = Math.max(0.0f, this.resetTimer - partial);
        }
        stack.m_85841_(scale, scale, scale);
        List<ItemStack> inputs = entity.getInventory().getNoneEmptyItems();
        for (int i = 0; i < inputs.size(); ++i) {
            stack.m_85836_();
            int itemRotation = MathUtils.flipCircle(Float.valueOf((float)i * 360.0f / (float)inputs.size()));
            double circleOffset = 0.0;
            if (progress > 0) {
                circleOffset = (double)(MathUtils.modifier(progress, processTime, 1.0f) * 360.0f * 3.0f) + this.oldCircleOffset;
            } else {
                this.oldCircleOffset = circleOffset = playerAngle;
            }
            float rotationDiff = MathUtils.singleRotation((double)(axisRotation + (float)itemRotation) - circleOffset);
            if (rotationDiff > 180.0f) {
                rotationDiff = 360.0f - rotationDiff;
            }
            float newHeight = rotationDiff / 180.0f * 2.0f;
            double playerOffset = Math.max(1.0 - altarPos.m_82554_(playerPos) / 8.0, 0.0);
            stack.m_252781_(Axis.f_252392_.m_252977_(MathUtils.singleRotation(Float.valueOf((float)itemRotation + axisRotation))));
            stack.m_252880_(0.0f, newHeight *= (float)playerOffset, -1.5f);
            ItemStack item = inputs.get(i);
            if (!item.m_41619_()) {
                this.mc.m_91291_().m_269128_(item, ItemDisplayContext.FIXED, lightAbove, overlay, stack, buffer, entity.m_58904_(), (int)entity.m_58899_().m_121878_());
            }
            stack.m_85849_();
        }
        if (processTime > 0 && progress >= processTime) {
            this.resetTimer = 60.0f;
        }
        stack.m_85849_();
    }
}

