/*
 * Decompiled with CFR 0.152.
 */
package dev.wuffs.squatgrow.actions;

import com.google.common.collect.ImmutableSet;
import dev.wuffs.squatgrow.actions.Action;
import dev.wuffs.squatgrow.actions.BoneMealAction;
import dev.wuffs.squatgrow.actions.RandomTickableAction;
import dev.wuffs.squatgrow.actions.integrations.AE2Action;
import dev.wuffs.squatgrow.actions.integrations.MysticalAction;
import dev.wuffs.squatgrow.actions.special.DirtToGrassAction;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Actions {
    INSTANCE;

    private static final Logger LOGGER;
    ImmutableSet<Action> actions;
    final Set<Supplier<Action>> possibleActions = new HashSet<Supplier<Action>>();

    private Actions() {
        this.register(RandomTickableAction::new);
        this.register(BoneMealAction::new);
        this.register(DirtToGrassAction::new);
        this.register(MysticalAction::new);
        this.register(AE2Action::new);
    }

    public void register(Supplier<Action> action) {
        this.possibleActions.add(action);
    }

    public void setup() {
        HashSet<Action> actions = new HashSet<Action>();
        for (Supplier<Action> action : this.possibleActions) {
            Action actualAction = action.get();
            if (!actualAction.isAvailable().getAsBoolean()) continue;
            actions.add(actualAction);
            LOGGER.info("Registered action: {}", (Object)action.getClass().getSimpleName());
        }
        this.actions = ImmutableSet.copyOf(actions);
    }

    public static Actions get() {
        return INSTANCE;
    }

    public ImmutableSet<Action> getActions() {
        return this.actions;
    }

    static {
        LOGGER = LoggerFactory.getLogger(Actions.class);
    }
}

