/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material.modifier;

import com.google.gson.JsonObject;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifier;
import net.silentchaos512.gear.api.material.modifier.IMaterialModifierType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ChargedProperties;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.util.Const;

public abstract class ChargedMaterialModifier
implements IMaterialModifier {
    protected final int level;

    protected ChargedMaterialModifier(int level) {
        this.level = level;
    }

    public ChargedProperties getChargedProperties(IMaterialInstance material) {
        return new ChargedProperties(this.level, material.getStat(PartType.MAIN, ItemStats.CHARGING_VALUE));
    }

    public static class Type<T extends ChargedMaterialModifier>
    implements IMaterialModifierType<T> {
        private final Function<Integer, T> factory;
        private final String nbtTagName;

        public Type(Function<Integer, T> factory, String nbtTagName) {
            this.factory = factory;
            this.nbtTagName = nbtTagName;
        }

        public int checkLevel(ItemStack stack) {
            return stack.m_41784_().m_128448_(this.nbtTagName);
        }

        public T create(int level) {
            return (T)((ChargedMaterialModifier)this.factory.apply(level));
        }

        @Override
        public ResourceLocation getId() {
            return Const.STARCHARGED;
        }

        @Override
        public void removeModifier(ItemStack stack) {
            if (!stack.m_41619_()) {
                stack.m_41784_().m_128473_(this.nbtTagName);
                stack.m_41784_().m_128473_("SG_IsFoil");
            }
        }

        boolean causesFoilEffect() {
            return true;
        }

        @Override
        @Nullable
        public T read(CompoundTag tag) {
            short level = tag.m_128448_(this.nbtTagName);
            if (level == 0) {
                return null;
            }
            return (T)((ChargedMaterialModifier)this.factory.apply(Integer.valueOf(level)));
        }

        @Override
        public void write(T modifier, CompoundTag tag) {
            tag.m_128376_(this.nbtTagName, (short)((ChargedMaterialModifier)modifier).level);
            if (this.causesFoilEffect()) {
                tag.m_128379_("SG_IsFoil", true);
            }
        }

        @Override
        public T readFromNetwork(FriendlyByteBuf buf) {
            byte level = buf.readByte();
            return this.create(level);
        }

        @Override
        public void writeToNetwork(T modifier, FriendlyByteBuf buf) {
            buf.writeByte(((ChargedMaterialModifier)modifier).level);
        }

        @Override
        public T deserialize(JsonObject json) {
            int level = GsonHelper.m_13824_((JsonObject)json, (String)"level", (int)0);
            return this.create(level);
        }

        @Override
        public JsonObject serialize(T modifier) {
            JsonObject json = new JsonObject();
            json.addProperty("level", (Number)((ChargedMaterialModifier)modifier).level);
            return json;
        }
    }
}

