/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonParseException;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialList;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;

public class ShapelessCompoundPartRecipe
extends ExtendedShapelessRecipe {
    private final CompoundPartItem item;

    public ShapelessCompoundPartRecipe(ShapelessRecipe recipe) {
        super(recipe);
        ItemStack output = recipe.m_8043_(null);
        if (!(output.m_41720_() instanceof CompoundPartItem)) {
            throw new JsonParseException("result is not a compound part item: " + output);
        }
        this.item = (CompoundPartItem)output.m_41720_();
    }

    protected GearType getGearType() {
        return this.item.getGearType();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SgRecipes.COMPOUND_PART.get();
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        if (!this.getBaseRecipe().m_5818_(inv, worldIn)) {
            return false;
        }
        IMaterial first = null;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            MaterialInstance mat = MaterialInstance.from(stack);
            if (mat == null) continue;
            if (!mat.get().isCraftingAllowed(mat, this.item.getPartType(), this.getGearType(), (Container)inv)) {
                return false;
            }
            if (first == null) {
                first = mat.get();
                continue;
            }
            if (((Boolean)Config.Common.allowLegacyMaterialMixing.get()).booleanValue() || first == mat.get()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess registryAccess) {
        int craftedCount = this.getBaseRecipe().m_8043_(registryAccess).m_41613_();
        return this.item.create(ShapelessCompoundPartRecipe.getMaterials((Container)inv), craftedCount);
    }

    private static MaterialList getMaterials(Container inv) {
        MaterialList ret = MaterialList.empty();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            MaterialInstance material;
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || (material = MaterialInstance.from(stack.m_41777_().m_41620_(1))) == null) continue;
            ret.add(material);
        }
        return ret;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        int craftedCount = this.getBaseRecipe().m_8043_(registryAccess).m_41613_();
        return this.item.create(MaterialList.of(new IMaterialInstance[]{LazyMaterialInstance.of(Const.Materials.EXAMPLE)}), craftedCount);
    }

    public boolean m_5598_() {
        return true;
    }
}

