/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;

public final class ConversionRecipe
extends ExtendedShapelessRecipe {
    private final Map<PartType, List<IMaterialInstance>> resultMaterials = new LinkedHashMap<PartType, List<IMaterialInstance>>();
    private final ICoreItem item;

    private ConversionRecipe(ShapelessRecipe recipe) {
        super(recipe);
        ItemStack output = recipe.m_8043_(null);
        if (!(output.m_41720_() instanceof ICoreItem)) {
            throw new JsonParseException("result is not a gear item: " + output);
        }
        this.item = (ICoreItem)output.m_41720_();
    }

    private static void deserializeMaterials(JsonObject json, ConversionRecipe recipe) {
        JsonObject resultJson = json.getAsJsonObject("result");
        for (Map.Entry entry : resultJson.getAsJsonObject("materials").entrySet()) {
            PartType partType = PartType.get(Objects.requireNonNull(SilentGear.getIdWithDefaultNamespace((String)entry.getKey())));
            JsonElement element = (JsonElement)entry.getValue();
            if (element.isJsonArray()) {
                ArrayList<LazyMaterialInstance> list = new ArrayList<LazyMaterialInstance>();
                for (JsonElement e : element.getAsJsonArray()) {
                    list.add(LazyMaterialInstance.deserialize(e.getAsJsonObject()));
                }
                recipe.resultMaterials.put(partType, list);
                continue;
            }
            recipe.resultMaterials.put(partType, Collections.singletonList(LazyMaterialInstance.deserialize(element.getAsJsonObject())));
        }
    }

    private static void readMaterials(FriendlyByteBuf buffer, ConversionRecipe recipe) {
        int typeCount = buffer.readByte();
        for (int i = 0; i < typeCount; ++i) {
            PartType partType = PartType.get(buffer.m_130281_());
            int matCount = buffer.readByte();
            ArrayList<LazyMaterialInstance> list = new ArrayList<LazyMaterialInstance>(matCount);
            for (int j = 0; j < matCount; ++j) {
                list.add(LazyMaterialInstance.read(buffer));
            }
            recipe.resultMaterials.put(partType, list);
        }
    }

    private static void writeMaterials(FriendlyByteBuf buffer, ConversionRecipe recipe) {
        buffer.writeByte(recipe.resultMaterials.size());
        recipe.resultMaterials.forEach((partType, list) -> {
            buffer.m_130085_(partType.getName());
            buffer.writeByte(list.size());
            list.forEach(mat -> mat.write(buffer));
        });
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SgRecipes.CONVERSION.get();
    }

    public boolean m_5818_(CraftingContainer inv, Level worldIn) {
        return (Boolean)Config.Common.allowConversionRecipes.get() != false && this.getBaseRecipe().m_5818_(inv, worldIn);
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack result = this.item.construct(this.getParts());
        ItemStack original = ConversionRecipe.findOriginalItem((Container)inv);
        if (!original.m_41619_()) {
            result.m_41721_(original.m_41773_());
            if (original.m_41793_()) {
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)original);
                EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)result);
            }
        }
        return result;
    }

    private static ItemStack findOriginalItem(Container inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41763_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    private Collection<? extends IPartData> getParts() {
        PartDataList ret = PartDataList.of(new PartData[0]);
        this.resultMaterials.forEach((partType, list) -> partType.getCompoundPartItem(this.item.getGearType()).ifPresent(partItem -> {
            PartData part = PartData.from(partItem.create((Collection<? extends IMaterialInstance>)list));
            if (part != null) {
                ret.add(part);
            }
        }));
        return ret;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    extends ExtendedShapelessRecipe.Serializer<ConversionRecipe> {
        public Serializer() {
            super(ConversionRecipe::new, ConversionRecipe::deserializeMaterials, ConversionRecipe::readMaterials, ConversionRecipe::writeMaterials);
        }
    }
}

