/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.item.FragmentItem;
import net.silentchaos512.gear.setup.SgItems;
import net.silentchaos512.gear.setup.SgRecipes;
import net.silentchaos512.lib.collection.StackList;
import net.silentchaos512.lib.crafting.ingredient.ExclusionIngredient;
import net.silentchaos512.lib.util.InventoryUtils;

public class CombineFragmentsRecipe
extends CustomRecipe {
    public CombineFragmentsRecipe(ResourceLocation idIn, CraftingBookCategory bookCategory) {
        super(idIn, bookCategory);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)SgRecipes.COMBINE_FRAGMENTS.get();
    }

    public boolean matches(CraftingContainer craftingInventory, Level world) {
        int fragmentCount = 0;
        for (int i = 0; i < craftingInventory.m_6643_(); ++i) {
            ItemStack stack = craftingInventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == SgItems.FRAGMENT.get()) {
                ++fragmentCount;
                continue;
            }
            return false;
        }
        if (fragmentCount != 8) {
            return false;
        }
        IMaterialInstance first = null;
        for (ItemStack stack : StackList.from((Container)craftingInventory)) {
            IMaterialInstance material = FragmentItem.getMaterial(stack);
            if (material == null) {
                return false;
            }
            if (first == null) {
                first = material;
                continue;
            }
            if (InventoryUtils.canItemsStack((ItemStack)material.getItem(), (ItemStack)first.getItem())) continue;
            return false;
        }
        return first != null;
    }

    public ItemStack assemble(CraftingContainer craftingInventory, RegistryAccess registryAccess) {
        StackList list = StackList.from((Container)craftingInventory);
        ItemStack stack = list.firstOfType(FragmentItem.class);
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        IMaterialInstance material = FragmentItem.getMaterial(stack);
        if (material == null) {
            return ItemStack.f_41583_;
        }
        if (!material.getItem().m_41619_()) {
            return material.getItem();
        }
        ItemStack[] matchingStacks = material.getIngredient().m_43908_();
        if (matchingStacks.length < 1) {
            ItemStack[] allMatches;
            if (material.getIngredient() instanceof ExclusionIngredient && (allMatches = ((ExclusionIngredient)material.getIngredient()).getMatchingStacksWithExclusions()).length > 0) {
                return allMatches[0];
            }
            return ItemStack.f_41583_;
        }
        return matchingStacks[0].m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 8;
    }
}

