/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.gamestages;

import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.compat.gamestages.GameStagesCompat;

public final class GameStagesCompatProxy {
    private GameStagesCompatProxy() {
        throw new IllegalAccessError("Utility class");
    }

    public static boolean canCraft(IGearPart part, CraftingContainer inv) {
        if (!ModList.get().isLoaded("gamestages")) {
            return true;
        }
        if (FMLEnvironment.dist == Dist.CLIENT) {
            Player player = SilentGear.PROXY.getClientPlayer();
            if (player == null || player instanceof FakePlayer) {
                return true;
            }
            return GameStagesCompatProxy.canCraft(part, player);
        }
        return GameStagesCompatProxy.canCraft(part, (Player)GameStagesCompatProxy.getPlayerUsingInventory(inv));
    }

    public static boolean canCraft(GearType gearType, CraftingContainer inv) {
        if (!ModList.get().isLoaded("gamestages")) {
            return true;
        }
        if (FMLEnvironment.dist == Dist.CLIENT) {
            Player player = SilentGear.PROXY.getClientPlayer();
            if (player == null || player instanceof FakePlayer) {
                return true;
            }
            return GameStagesCompatProxy.canCraft(gearType, player);
        }
        return GameStagesCompatProxy.canCraft(gearType, (Player)GameStagesCompatProxy.getPlayerUsingInventory(inv));
    }

    public static boolean canCraft(IGearPart part, Player player) {
        if (!ModList.get().isLoaded("gamestages")) {
            return true;
        }
        return GameStagesCompat.canCraft(part, player);
    }

    public static boolean canCraft(@Nullable GearType gearType, Player player) {
        if (!ModList.get().isLoaded("gamestages") || gearType == null) {
            return true;
        }
        return GameStagesCompat.canCraft(gearType, player);
    }

    @Nullable
    private static ServerPlayer getPlayerUsingInventory(CraftingContainer inv) {
        MinecraftServer server = SilentGear.PROXY.getServer();
        if (server != null) {
            PlayerList manager = server.m_6846_();
            Field containerField = ObfuscationReflectionHelper.findField(CraftingContainer.class, (String)"eventHandler");
            containerField.setAccessible(true);
            AbstractContainerMenu container = null;
            try {
                container = (AbstractContainerMenu)containerField.get(inv);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (container == null) {
                return null;
            }
            ServerPlayer foundPlayer = null;
            for (ServerPlayer player : manager.m_11314_()) {
                if (player.f_36096_ != container || !container.m_6875_((Player)player)) continue;
                if (foundPlayer != null) {
                    return null;
                }
                foundPlayer = player;
            }
            return foundPlayer;
        }
        return null;
    }
}

