/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.event;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ExtraBlockBreakHandler
extends SimpleJsonResourceReloadListener {
    public static final ExtraBlockBreakHandler INSTANCE = new ExtraBlockBreakHandler(Minecraft.m_91087_());
    private final Map<Integer, DestroyExtraBlocksProgress> extraDamagedBlocks = new HashMap<Integer, DestroyExtraBlocksProgress>();
    private Minecraft mc;

    private ExtraBlockBreakHandler(Minecraft mcIn) {
        super(new GsonBuilder().create(), "extra_block_break_handler");
        this.mc = mcIn;
    }

    @SubscribeEvent
    public void worldUnload(LevelEvent.Unload event) {
        this.extraDamagedBlocks.clear();
    }

    @SubscribeEvent
    public void worldLoad(LevelEvent.Load event) {
        this.extraDamagedBlocks.clear();
    }

    private static void preRenderDamagedBlocks() {
    }

    private static void postRenderDamagedBlocks() {
    }

    private void drawBlockDamageTexture(Tesselator tessellatorIn, BufferBuilder bufferBuilderIn, Entity entityIn, float partialTicks) {
    }

    private void cleanupExtraDamagedBlocks() {
        for (Map.Entry<Integer, DestroyExtraBlocksProgress> entry : this.extraDamagedBlocks.entrySet()) {
            DestroyExtraBlocksProgress destroyblockprogress = entry.getValue();
            int k1 = destroyblockprogress.getCreationWorldTick();
            if (this.mc.f_91073_.m_46467_() - (long)k1 <= 400L) continue;
            this.extraDamagedBlocks.remove(entry.getKey());
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> p_10793_, ResourceManager p_10794_, ProfilerFiller p_10795_) {
    }

    public void sendBlockBreakProgress(int breakerId, BlockPos[] positions, int progress) {
        if (positions.length > 0 && progress >= 0 && progress < 10) {
            DestroyExtraBlocksProgress destroyextrablocksprogress = new DestroyExtraBlocksProgress(breakerId, positions);
            this.extraDamagedBlocks.put(breakerId, destroyextrablocksprogress);
            destroyextrablocksprogress.setPartialBlockDamage(progress);
            destroyextrablocksprogress.setWorldTick((int)this.mc.f_91073_.m_46467_());
        } else {
            this.extraDamagedBlocks.remove(breakerId);
        }
    }

    private static class DestroyExtraBlocksProgress {
        private final int miningPlayerEntId;
        private final BlockPos[] positions;
        private int partialBlockProgress;
        private int createdAtWorldTick;

        public DestroyExtraBlocksProgress(int miningPlayerEntIdIn, BlockPos ... positionsIn) {
            this.miningPlayerEntId = miningPlayerEntIdIn;
            this.positions = positionsIn;
        }

        public BlockPos[] getPositions() {
            return this.positions;
        }

        public void setPartialBlockDamage(int damage) {
            if (damage > 10) {
                damage = 10;
            }
            this.partialBlockProgress = damage;
        }

        public int getPartialBlockDamage() {
            return this.partialBlockProgress;
        }

        public void setWorldTick(int createdAtWorldTickIn) {
            this.createdAtWorldTick = createdAtWorldTickIn;
        }

        public int getCreationWorldTick() {
            return this.createdAtWorldTick;
        }
    }
}

