/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.api.ApiConst;
import net.silentchaos512.gear.api.data.trait.TraitBuilder;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.lib.util.TimeUtils;

public class WielderEffectTraitBuilder
extends TraitBuilder {
    private final Map<GearType, List<PotionData>> potions = new LinkedHashMap<GearType, List<PotionData>>();

    public WielderEffectTraitBuilder(DataResource<ITrait> trait, int maxLevel) {
        this(trait.getId(), maxLevel);
    }

    public WielderEffectTraitBuilder(ResourceLocation traitId, int maxLevel) {
        super(traitId, maxLevel, (ResourceLocation)ApiConst.WIELDER_EFFECT_TRAIT_ID);
    }

    public WielderEffectTraitBuilder(DataResource<ITrait> trait, int maxLevel, ResourceLocation serializerName) {
        this(trait.getId(), maxLevel, serializerName);
    }

    public WielderEffectTraitBuilder(ResourceLocation traitId, int maxLevel, ResourceLocation serializerName) {
        super(traitId, maxLevel, serializerName);
    }

    @Deprecated
    public WielderEffectTraitBuilder addEffect(GearType gearType, boolean requiresFullSet, MobEffect effect, int ... levels) {
        this.potions.computeIfAbsent(gearType, gt -> new ArrayList()).add(PotionData.of(requiresFullSet, effect, levels));
        return this;
    }

    public WielderEffectTraitBuilder addEffect(GearType gearType, LevelType type, MobEffect effect, int ... levels) {
        this.potions.computeIfAbsent(gearType, gt -> new ArrayList()).add(PotionData.of(type, effect, levels));
        return this;
    }

    @Override
    public JsonObject serialize() {
        if (this.potions.isEmpty()) {
            throw new IllegalStateException("Potion effect trait '" + this.getTraitId() + "' has no effects");
        }
        JsonObject json = super.serialize();
        JsonObject effectsJson = new JsonObject();
        this.potions.forEach((gearType, effects) -> {
            JsonArray array = new JsonArray();
            effects.forEach(e -> array.add((JsonElement)e.serialize()));
            effectsJson.add(gearType.getName(), (JsonElement)array);
        });
        json.add("potion_effects", (JsonElement)effectsJson);
        return json;
    }

    public static class PotionData {
        private LevelType type;
        private ResourceLocation effectId;
        private int duration;
        private int[] levels;

        @Deprecated
        public static PotionData of(boolean requiresFullSet, MobEffect effect, int ... levels) {
            return PotionData.of(requiresFullSet ? LevelType.FULL_SET_ONLY : LevelType.PIECE_COUNT, effect, levels);
        }

        public static PotionData of(LevelType type, MobEffect effect, int ... levels) {
            PotionData ret = new PotionData();
            ret.type = type;
            ret.effectId = Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect));
            ret.duration = TimeUtils.ticksFromSeconds((float)PotionData.getDefaultDuration(ret.effectId));
            ret.levels = (int[])levels.clone();
            return ret;
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("type", this.type.getName());
            json.addProperty("effect", this.effectId.toString());
            JsonArray levelsArray = new JsonArray();
            Arrays.stream(this.levels).forEach(arg_0 -> ((JsonArray)levelsArray).add(arg_0));
            json.add("level", (JsonElement)levelsArray);
            return json;
        }

        private static float getDefaultDuration(ResourceLocation effectId) {
            return new ResourceLocation("night_vision").equals((Object)effectId) ? 15.9f : 1.9f;
        }
    }

    public static enum LevelType {
        TRAIT_LEVEL,
        PIECE_COUNT,
        FULL_SET_ONLY;


        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

