/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.data.trait;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.silentchaos512.gear.api.ApiConst;
import net.silentchaos512.gear.api.data.trait.TraitBuilder;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.util.DataResource;

public class BlockMiningSpeedTraitBuilder
extends TraitBuilder {
    private final float speedMultiplier;
    private final Collection<TagKey<Block>> blocks;

    public BlockMiningSpeedTraitBuilder(DataResource<ITrait> trait, int maxLevel, float speedMultiplier, TagKey<Block> block) {
        this(trait, maxLevel, speedMultiplier, Collections.singleton(block));
    }

    public BlockMiningSpeedTraitBuilder(DataResource<ITrait> trait, int maxLevel, float speedMultiplier, Collection<TagKey<Block>> blocks) {
        super(trait, maxLevel, (ResourceLocation)ApiConst.BLOCK_MINING_SPEED_TRAIT_ID);
        this.speedMultiplier = speedMultiplier;
        this.blocks = Sets.newHashSet(blocks);
    }

    @Override
    public JsonObject serialize() {
        JsonObject json = super.serialize();
        json.addProperty("speed_multiplier", (Number)Float.valueOf(this.speedMultiplier));
        JsonArray array = new JsonArray();
        this.blocks.forEach(tag -> array.add(tag.f_203868_().toString()));
        json.add("blocks", (JsonElement)array);
        return json;
    }
}

