/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import java.util.Map;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.network.PacketReturnScreenData;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketGetScreenData(String modid, GlobalPos pos, Long millis) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsutility", "getscreendata");

    public static PacketGetScreenData create(String modid, GlobalPos pos, long millis) {
        return new PacketGetScreenData(modid, pos, millis);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130070_(this.modid);
        buf.m_130064_(this.pos.m_122646_());
        buf.m_130085_(this.pos.m_122640_().m_135782_());
        buf.writeLong(this.millis.longValue());
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketGetScreenData create(FriendlyByteBuf buf) {
        String modid = buf.m_130136_(Short.MAX_VALUE);
        BlockPos pos = buf.m_130135_();
        ResourceKey id = LevelTools.getId((ResourceLocation)buf.m_130281_());
        GlobalPos gpos = GlobalPos.m_122643_((ResourceKey)id, (BlockPos)pos);
        long millis = buf.readLong();
        return new PacketGetScreenData(modid, gpos, millis);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> {
            BlockEntity patt2123$temp;
            Level world = player.m_20193_();
            if ((world = LevelTools.getLevel((Level)world, (ResourceKey)this.pos.m_122640_())).m_46805_(this.pos.m_122646_()) && (patt2123$temp = world.m_7702_(this.pos.m_122646_())) instanceof ScreenTileEntity) {
                ScreenTileEntity screen = (ScreenTileEntity)patt2123$temp;
                Map<Integer, IModuleData> screenData = screen.getScreenData(this.millis);
                PacketReturnScreenData msg = new PacketReturnScreenData(this.pos, screenData);
                RFToolsUtilityMessages.sendToPlayer(msg, player);
            }
        }));
    }
}

