/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.modularstorage.network;

import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsstorage.modules.modularstorage.blocks.ModularStorageTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketStorageInfoToClient(BlockPos pos, String sortMode, String viewMode, Boolean groupMode, String filter, Boolean locked) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsstorage", "storageinfotoclient");

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.viewMode);
        buf.m_130070_(this.sortMode);
        buf.writeBoolean(this.groupMode.booleanValue());
        buf.m_130070_(this.filter);
        buf.writeBoolean(this.locked.booleanValue());
    }

    public ResourceLocation id() {
        return ID;
    }

    public static PacketStorageInfoToClient create(FriendlyByteBuf buf) {
        return new PacketStorageInfoToClient(buf.m_130135_(), buf.m_130136_(Short.MAX_VALUE), buf.m_130136_(Short.MAX_VALUE), buf.readBoolean(), buf.m_130136_(Short.MAX_VALUE), buf.readBoolean());
    }

    public static PacketStorageInfoToClient create(BlockPos pos, String sortMode, String viewMode, boolean groupMode, String filter, boolean locked) {
        return new PacketStorageInfoToClient(pos, sortMode, viewMode, groupMode, filter, locked);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            BlockEntity te = SafeClientTools.getClientWorld().m_7702_(this.pos);
            if (te instanceof ModularStorageTileEntity) {
                ModularStorageTileEntity storage = (ModularStorageTileEntity)te;
                storage.syncInventoryFromServer(this.sortMode, this.viewMode, this.groupMode, this.filter, this.locked);
            }
        });
    }
}

