/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.tools;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.client.RenderHelper;
import mcjty.rftoolsbase.api.screens.ITextRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.TextAlign;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;

public class ScreenTextHelper
implements ITextRenderHelper {
    private boolean large = false;
    private TextAlign align = TextAlign.ALIGN_LEFT;
    private boolean dirty = true;
    private int textx;
    private String text;
    private boolean truetype = false;
    private ResourceLocation fontId;
    private static final Map<ResourceLocation, Font> trueTypeRenderer = new HashMap<ResourceLocation, Font>();

    public int getTextx() {
        return this.textx;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isLarge() {
        return this.large;
    }

    @Override
    public ITextRenderHelper large(boolean large) {
        this.dirty = true;
        this.large = large;
        return this;
    }

    @Override
    public TextAlign getAlign() {
        return this.align;
    }

    @Override
    public ITextRenderHelper align(TextAlign align) {
        this.dirty = true;
        this.align = align;
        return this;
    }

    @Override
    public void setup(String line, int width, ModuleRenderInfo renderInfo) {
        if (!this.dirty && this.truetype == renderInfo.truetype) {
            return;
        }
        this.dirty = false;
        this.truetype = renderInfo.truetype;
        this.fontId = renderInfo.fontId;
        Font renderer = ScreenTextHelper.getFontRenderer(this.truetype, this.fontId);
        int n = this.textx = this.large ? 4 : 7;
        if (this.truetype) {
            width *= 2;
        }
        this.text = renderer.m_92834_(line, (this.large ? width / 8 : width / 4) - this.textx);
        int w = this.large ? (int)((float)width / 8.8f) : (int)((float)width / 4.45f);
        switch (this.align) {
            case ALIGN_LEFT: {
                break;
            }
            case ALIGN_CENTER: {
                this.textx += (w - renderer.m_92895_(this.text)) / 2;
                break;
            }
            case ALIGN_RIGHT: {
                this.textx += w - renderer.m_92895_(this.text);
            }
        }
    }

    @Override
    public void renderText(GuiGraphics graphics, MultiBufferSource buffer, int x, int y, int color, ModuleRenderInfo renderInfo) {
        ScreenTextHelper.renderScaled(this.fontId, graphics, buffer, this.text, this.textx + x, y, color, this.truetype, renderInfo.getLightmapValue());
    }

    public static void renderScaled(ResourceLocation fontId, GuiGraphics graphics, MultiBufferSource buffer, String text, int x, int y, int color, boolean truetype, int lightmapValue) {
        PoseStack matrixStack = graphics.m_280168_();
        Font renderer = ScreenTextHelper.getFontRenderer(truetype, fontId);
        if (truetype) {
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            RenderHelper.renderText((Font)renderer, (String)text, (int)(x * 2), (int)(y * 2), (int)(0xFF000000 | color), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)lightmapValue);
            matrixStack.m_85849_();
        } else {
            RenderHelper.renderText((Font)renderer, (String)text, (int)x, (int)y, (int)(0xFF000000 | color), (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)lightmapValue);
        }
    }

    public static void renderScaledTrimmed(ResourceLocation fontId, PoseStack matrixStack, MultiBufferSource buffer, String text, int x, int y, int maxwidth, int color, boolean truetype, int lightmapValue) {
        Font renderer = ScreenTextHelper.getFontRenderer(truetype, fontId);
        if (truetype) {
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
            text = renderer.m_92834_(text, maxwidth * 2);
            RenderHelper.renderText((Font)renderer, (String)text, (int)(x * 2), (int)(y * 2), (int)color, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)lightmapValue);
            matrixStack.m_85849_();
        } else {
            text = renderer.m_92834_(text, maxwidth);
            RenderHelper.renderText((Font)renderer, (String)text, (int)(x * 2), (int)(y * 2), (int)color, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)lightmapValue);
        }
    }

    private static Font getFontRenderer(boolean truetype, ResourceLocation fontId) {
        if (truetype) {
            if (!trueTypeRenderer.containsKey(fontId)) {
                FontSet font = (FontSet)Minecraft.m_91087_().f_91045_.f_94999_.get(fontId);
                trueTypeRenderer.put(fontId, new Font(resourceLocation -> font, false));
            }
            return trueTypeRenderer.get(fontId);
        }
        return Minecraft.m_91087_().f_91062_;
    }
}

