/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItem;
import reliquary.items.ToggleableItem;
import reliquary.items.util.IScrollableItem;
import reliquary.items.util.fluid.FluidHandlerHeroMedallion;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;
import reliquary.util.NBTHelper;
import reliquary.util.TooltipBuilder;
import reliquary.util.XpHelper;

public class HeroMedallionItem
extends ToggleableItem
implements IPedestalActionItem,
IScrollableItem {
    private static final String EXPERIENCE_TAG = "experience";

    public HeroMedallionItem() {
        super(new Item.Properties().m_41503_(0).setNoRepair());
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return NBTHelper.getBoolean("enabled", stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack medallion, @Nullable Level world, TooltipBuilder tooltipBuilder) {
        int experience = NBTHelper.getInt(EXPERIENCE_TAG, medallion);
        int levels = XpHelper.getLevelForExperience(experience);
        int remainingExperience = experience - XpHelper.getExperienceForLevel(levels);
        tooltipBuilder.data(this, ".tooltip2", levels, remainingExperience);
        tooltipBuilder.description(this, ".tooltip.drain_levels", Component.m_237113_((String)String.valueOf(this.getDrainXpLevels(medallion))).m_130940_(ChatFormatting.RED));
        if (this.isEnabled(medallion)) {
            tooltipBuilder.absorbActive((Component)Component.m_237115_((String)"tooltip.reliquary.xp").m_130940_(ChatFormatting.GREEN));
            tooltipBuilder.description(this, ".tooltip.fill_stop_level", Component.m_237113_((String)String.valueOf(this.getStopAtXpLevel(medallion))).m_130940_(ChatFormatting.GREEN));
        } else {
            tooltipBuilder.absorb();
        }
        tooltipBuilder.description(this, ".tooltip.scroll_to_change", new Object[0]);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        Player player;
        if (world.f_46443_ || !this.isEnabled(stack) || world.m_46467_() % 10L != 0L) {
            return;
        }
        if (entity instanceof Player && (!(player = (Player)entity).m_6117_() || player.m_21211_() != stack)) {
            this.drainExperienceLevel(stack, player);
        }
    }

    private void drainExperienceLevel(ItemStack stack, Player player) {
        int experiencePoints;
        int n = experiencePoints = player.m_7500_() ? 100 : XpHelper.getTotalPlayerExperience(player) - XpHelper.getExperienceForLevel(Math.max(this.getStopAtXpLevel(stack), player.f_36078_ - 1));
        if (experiencePoints > 0) {
            if (!player.m_7500_()) {
                this.decreasePlayerExperience(player, experiencePoints);
            }
            this.increaseMedallionExperience(stack, experiencePoints);
        }
    }

    private void decreasePlayerExperience(Player player, int pointsToRemove) {
        int newLevel;
        HeroMedallionItem.correctTotalExperience(player);
        player.f_36079_ -= pointsToRemove;
        player.f_36078_ = newLevel = XpHelper.getLevelForExperience(player.f_36079_);
        player.f_36080_ = (float)(player.f_36079_ - XpHelper.getExperienceForLevel(newLevel)) / (float)player.m_36323_();
    }

    private static void correctTotalExperience(Player player) {
        player.f_36079_ = XpHelper.getExperienceForLevel(player.f_36078_) + (int)((float)XpHelper.getExperienceLimitOnLevel(player.f_36078_) * player.f_36080_);
    }

    private void decreaseMedallionExperience(ItemStack stack, int experience) {
        this.setExperience(stack, this.getExperience(stack) - experience);
    }

    private void increasePlayerExperience(Player player, int xpPoints) {
        player.m_6756_(xpPoints);
    }

    private void increaseMedallionExperience(ItemStack stack, int xpPoints) {
        this.setExperience(stack, this.getExperience(stack) + xpPoints);
    }

    public int getExperience(ItemStack stack) {
        return NBTHelper.getInt(EXPERIENCE_TAG, stack);
    }

    public void setExperience(ItemStack stack, int i) {
        NBTHelper.putInt(EXPERIENCE_TAG, stack, i);
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (level.f_46443_) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (player.m_6144_()) {
            return super.m_7203_(level, player, hand);
        }
        this.drainExperience(stack, player, level, this.getDrainXpLevels(stack));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void drainExperience(ItemStack stack, Player player, Level level, int xpLevels) {
        BlockHitResult rayTraceResult = HeroMedallionItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (rayTraceResult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos hitPos = rayTraceResult.m_82425_().m_121955_(rayTraceResult.m_82434_().m_122436_());
            this.spawnXpOnGround(stack, level, hitPos, xpLevels);
        } else {
            int maxPoints = XpHelper.getExperienceForLevel(player.f_36078_ + (xpLevels += Math.round(player.f_36080_))) - XpHelper.getTotalPlayerExperience(player);
            int pointsToAdd = player.m_7500_() ? maxPoints : Math.min(maxPoints, this.getExperience(stack));
            this.increasePlayerExperience(player, pointsToAdd);
            if (!player.m_7500_()) {
                this.decreaseMedallionExperience(stack, pointsToAdd);
            }
        }
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving.m_9236_().f_46443_ || this.isEnabled(stack) || !(entityLiving instanceof Player) || this.m_8105_(stack) - timeLeft > 10) {
            return;
        }
        this.drainExperience(stack, (Player)entityLiving, entityLiving.m_9236_(), 1);
    }

    private void spawnXpOnGround(ItemStack stack, Level world, BlockPos hitPos, int xpLevels) {
        int xp;
        if (this.getExperience(stack) >= xp) {
            int j;
            this.decreaseMedallionExperience(stack, xp);
            for (xp = XpHelper.getExperienceForLevel(xpLevels); xp > 0; xp -= j) {
                j = ExperienceOrb.m_20782_((int)xp);
                world.m_7967_((Entity)new ExperienceOrb(world, (double)hitPos.m_123341_(), (double)hitPos.m_123342_(), (double)hitPos.m_123343_(), j));
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new FluidHandlerHeroMedallion(stack);
    }

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        List<BlockPos> posInRange = pedestal.getPedestalsInRange(level, (Integer)Settings.COMMON.items.heroMedallion.pedestalRange.get());
        for (BlockPos pedestalPos : posInRange) {
            InventoryHelper.getInventoryAtPos(level, pedestalPos).ifPresent(pedestalInventory -> {
                List<ItemStack> toRepair = this.getMendingItemsForRepair((IItemHandler)pedestalInventory);
                for (ItemStack itemToRepair : toRepair) {
                    int xpToRepair = Math.min((Integer)Settings.COMMON.items.heroMedallion.pedestalRepairStepXP.get(), this.getExperience(stack));
                    int durabilityToRepair = Math.min(XpHelper.xpToDurability(xpToRepair), itemToRepair.m_41773_());
                    this.setExperience(stack, this.getExperience(stack) - XpHelper.durabilityToXp(durabilityToRepair));
                    itemToRepair.m_41721_(itemToRepair.m_41773_() - durabilityToRepair);
                }
            });
        }
        pedestal.setActionCoolDown((Integer)Settings.COMMON.items.heroMedallion.pedestalCoolDown.get());
    }

    private List<ItemStack> getMendingItemsForRepair(IItemHandler inventory) {
        NonNullList stacksToReturn = NonNullList.m_122779_();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (!stack.m_41768_() || stack.m_41773_() <= 1 || stack.getEnchantmentLevel(Enchantments.f_44962_) <= 0) continue;
            stacksToReturn.add((Object)stack);
        }
        return stacksToReturn;
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }

    @Override
    public InteractionResult onMouseScrolled(ItemStack stack, Player player, double scrollDelta) {
        int levelAddition;
        if (player.m_9236_().f_46443_) {
            return InteractionResult.PASS;
        }
        int n = levelAddition = scrollDelta > 0.0 ? 1 : -1;
        if (this.isEnabled(stack)) {
            int newLevels = Math.max(0, this.getStopAtXpLevel(stack) + levelAddition);
            this.setStopAtXpLevel(stack, newLevels);
            player.m_5661_((Component)Component.m_237110_((String)"chat.reliquary.hero_medallion.fill_levels", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(newLevels)).m_130940_(ChatFormatting.GREEN)}), true);
        } else {
            int newLevels = Math.max(1, this.getDrainXpLevels(stack) + levelAddition);
            this.setDrainXpLevels(stack, newLevels);
            player.m_5661_((Component)Component.m_237110_((String)"chat.reliquary.hero_medallion.drain_levels", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(newLevels)).m_130940_(ChatFormatting.RED)}), true);
        }
        return InteractionResult.SUCCESS;
    }

    private int getDrainXpLevels(ItemStack stack) {
        return NBTHelper.getInt(stack, "drainXpLevels").orElse(1);
    }

    private int getStopAtXpLevel(ItemStack stack) {
        return NBTHelper.getInt(stack, "stopAtXpLevel").orElse(0);
    }

    private void setDrainXpLevels(ItemStack stack, int levels) {
        NBTHelper.putInt("drainXpLevels", stack, levels);
    }

    private void setStopAtXpLevel(ItemStack stack, int levels) {
        NBTHelper.putInt("stopAtXpLevel", stack, levels);
    }
}

