/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.shot;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import reliquary.entities.shot.ShotEntityBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class SeekerShotEntity
extends ShotEntityBase {
    public SeekerShotEntity(EntityType<SeekerShotEntity> entityType, Level world) {
        super(entityType, world);
    }

    public SeekerShotEntity(Level world, Player player, InteractionHand hand) {
        super((EntityType)ModEntities.SEEKER_SHOT.get(), world, player, hand);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, this.gaussian(1.0), this.gaussian(1.0));
        }
        this.seekTarget();
    }

    @Override
    void doFiringEffects() {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_() + this.smallGauss(0.1), this.m_20186_() + this.smallGauss(0.1), this.m_20189_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123744_);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_() + this.smallGauss(0.1), this.m_20186_() + this.smallGauss(0.1), this.m_20189_() + this.smallGauss(0.1), (double)0.1f, 1.0, 1.0);
        }
    }

    @Override
    int getRicochetMax() {
        return 3;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return 10 + this.d12();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.SEEKER;
    }
}

