/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.util;

import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.RSItems;
import com.refinedmods.refinedstorage.block.BaseBlock;
import com.refinedmods.refinedstorage.block.BlockDirection;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.item.blockitem.ColoredBlockItem;
import com.refinedmods.refinedstorage.util.BlockUtils;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ColorMap<T> {
    public static final DyeColor DEFAULT_COLOR = DyeColor.LIGHT_BLUE;
    private final Map<DyeColor, RegistryObject<T>> map = new EnumMap<DyeColor, RegistryObject<T>>(DyeColor.class);
    private final Map<T, DyeColor> colorByBlock = new HashMap<T, DyeColor>();
    private DeferredRegister<Item> itemRegister;
    private DeferredRegister<Block> blockRegister;
    private List<Runnable> lateRegistration;

    public ColorMap(DeferredRegister<Block> blockRegister) {
        this.blockRegister = blockRegister;
    }

    public ColorMap(DeferredRegister<Item> itemRegister, List<Runnable> lateRegistration) {
        this.itemRegister = itemRegister;
        this.lateRegistration = lateRegistration;
    }

    public RegistryObject<T> get(DyeColor color) {
        return this.map.get(color);
    }

    public DyeColor getColorFromObject(T object) {
        if (this.colorByBlock.isEmpty()) {
            this.map.forEach((? super K dyeColor, ? super V registryObject) -> this.colorByBlock.put((T)registryObject.get(), (DyeColor)dyeColor));
        }
        return this.colorByBlock.get(object);
    }

    public Collection<RegistryObject<T>> values() {
        return this.map.values();
    }

    public void put(DyeColor color, RegistryObject<T> object) {
        this.map.put(color, object);
    }

    public void forEach(BiConsumer<DyeColor, RegistryObject<T>> consumer) {
        this.map.forEach(consumer);
    }

    public Block[] getBlocks() {
        return (Block[])this.map.values().stream().map(RegistryObject::get).toArray(Block[]::new);
    }

    public <S extends Block> void registerBlocks(String name, Supplier<S> blockFactory) {
        for (DyeColor color : DyeColor.values()) {
            Object prefix = color != DEFAULT_COLOR ? color + "_" : "";
            RegistryObject block = this.blockRegister.register((String)prefix + name, blockFactory);
            this.map.put(color, block);
            RSBlocks.COLORED_BLOCKS.add((RegistryObject<? extends Block>)block);
        }
        RSBlocks.COLORED_BLOCK_TAGS.put((TagKey<Block>)BlockTags.create((ResourceLocation)new ResourceLocation("refinedstorage", this.get(DEFAULT_COLOR).getId().m_135815_())), this);
    }

    public <S extends BaseBlock> void registerItemsFromBlocks(ColorMap<S> blockMap) {
        RegistryObject originalBlock = blockMap.get(DEFAULT_COLOR);
        this.map.put(DEFAULT_COLOR, this.registerBlockItemFor(originalBlock, DEFAULT_COLOR, originalBlock));
        this.lateRegistration.add(() -> blockMap.forEach((color, block) -> {
            if (color != DEFAULT_COLOR) {
                this.map.put((DyeColor)color, this.registerBlockItemFor((RegistryObject)block, (DyeColor)color, originalBlock));
            }
        }));
        RSItems.COLORED_ITEM_TAGS.put((TagKey<Item>)ItemTags.create((ResourceLocation)new ResourceLocation("refinedstorage", blockMap.get(DEFAULT_COLOR).getId().m_135815_())), this);
    }

    private <S extends BaseBlock> RegistryObject<T> registerBlockItemFor(RegistryObject<S> block, DyeColor color, RegistryObject<S> translationBlock) {
        return this.itemRegister.register(block.getId().m_135815_(), () -> new ColoredBlockItem((BaseBlock)((Object)((Object)block.get())), new Item.Properties(), color, BlockUtils.getBlockTranslation((Block)translationBlock.get())));
    }

    public <S extends BaseBlock> InteractionResult changeBlockColor(BlockState state, ItemStack heldItem, Level level, BlockPos pos, Player player) {
        DyeColor color = DyeColor.getColor((ItemStack)heldItem);
        if (color == null || state.m_60734_().equals(this.map.get(color).get())) {
            return InteractionResult.PASS;
        }
        return this.setBlockState(this.getNewState(this.map.get(color), state), heldItem, level, pos, player);
    }

    private <S extends BaseBlock> BlockState getNewState(RegistryObject<S> block, BlockState state) {
        BlockState newState = ((BaseBlock)((Object)block.get())).m_49966_();
        if (((NetworkNodeBlock)((Object)block.get())).hasConnectedState()) {
            newState = (BlockState)newState.m_61124_((Property)NetworkNodeBlock.CONNECTED, (Comparable)((Boolean)state.m_61143_((Property)NetworkNodeBlock.CONNECTED)));
        }
        if (((BaseBlock)((Object)block.get())).getDirection() != BlockDirection.NONE) {
            newState = (BlockState)newState.m_61124_((Property)((BaseBlock)((Object)block.get())).getDirection().getProperty(), (Comparable)((Direction)state.m_61143_((Property)((BaseBlock)((Object)block.get())).getDirection().getProperty())));
        }
        return newState;
    }

    public InteractionResult setBlockState(BlockState newState, ItemStack heldItem, Level level, BlockPos pos, Player player) {
        if (!level.f_46443_) {
            level.m_46597_(pos, newState);
            if (((ServerPlayer)player).f_8941_.m_9290_() != GameType.CREATIVE) {
                heldItem.m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

