/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.container;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.apiimpl.API;
import com.refinedmods.refinedstorage.blockentity.BaseBlockEntity;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationWatcher;
import com.refinedmods.refinedstorage.container.slot.filter.FilterSlot;
import com.refinedmods.refinedstorage.container.slot.filter.FluidFilterSlot;
import com.refinedmods.refinedstorage.container.slot.legacy.LegacyDisabledSlot;
import com.refinedmods.refinedstorage.container.slot.legacy.LegacyFilterSlot;
import com.refinedmods.refinedstorage.container.transfer.TransferManager;
import com.refinedmods.refinedstorage.network.FluidFilterSlotUpdateMessage;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class BaseContainerMenu
extends AbstractContainerMenu {
    protected final TransferManager transferManager = new TransferManager(this);
    @Nullable
    private final BaseBlockEntity blockEntity;
    private final Player player;
    private final List<FluidFilterSlot> fluidSlots = new ArrayList<FluidFilterSlot>();
    private final List<FluidStack> fluids = new ArrayList<FluidStack>();
    @Nullable
    private BlockEntitySynchronizationWatcher listener;

    protected BaseContainerMenu(@Nullable MenuType<?> type, @Nullable BaseBlockEntity blockEntity, Player player, int windowId) {
        super(type, windowId);
        this.blockEntity = blockEntity;
        if (blockEntity != null && player instanceof ServerPlayer) {
            this.listener = new BlockEntitySynchronizationWatcher((ServerPlayer)player, blockEntity.getDataManager());
        }
        this.player = player;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Nullable
    public BaseBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    protected void addPlayerInventory(int xInventory, int yInventory) {
        int x;
        int disabledSlotNumber = this.getDisabledSlotNumber();
        int id = 9;
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                if (id == disabledSlotNumber) {
                    this.m_38897_(new LegacyDisabledSlot((Container)this.player.m_150109_(), id, xInventory + x * 18, yInventory + y * 18));
                } else {
                    this.m_38897_(new Slot((Container)this.player.m_150109_(), id, xInventory + x * 18, yInventory + y * 18));
                }
                ++id;
            }
        }
        id = 0;
        for (int i = 0; i < 9; ++i) {
            x = xInventory + i * 18;
            int y = yInventory + 4 + 54;
            if (id == disabledSlotNumber) {
                this.m_38897_(new LegacyDisabledSlot((Container)this.player.m_150109_(), id, x, y));
            } else {
                this.m_38897_(new Slot((Container)this.player.m_150109_(), id, x, y));
            }
            ++id;
        }
    }

    public List<FluidFilterSlot> getFluidSlots() {
        return this.fluidSlots;
    }

    public void m_150399_(int id, int dragType, ClickType clickType, Player player) {
        Slot slot = id >= 0 ? this.m_38853_(id) : null;
        int disabledSlotNumber = this.getDisabledSlotNumber();
        if (disabledSlotNumber != -1 && clickType == ClickType.SWAP && dragType == disabledSlotNumber) {
            return;
        }
        if (slot instanceof FilterSlot) {
            if (((FilterSlot)slot).isSizeAllowed()) {
                if (clickType == ClickType.QUICK_MOVE) {
                    slot.m_5852_(ItemStack.f_41583_);
                } else if (!player.f_36096_.m_142621_().m_41619_()) {
                    slot.m_5852_(player.f_36096_.m_142621_().m_41777_());
                }
            } else if (player.f_36096_.m_142621_().m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else if (slot.m_5857_(player.f_36096_.m_142621_())) {
                slot.m_5852_(player.f_36096_.m_142621_().m_41777_());
            }
            return;
        }
        if (slot instanceof FluidFilterSlot) {
            if (((FluidFilterSlot)slot).isSizeAllowed()) {
                if (clickType == ClickType.QUICK_MOVE) {
                    ((FluidFilterSlot)slot).onContainerClicked(ItemStack.f_41583_);
                } else if (!player.f_36096_.m_142621_().m_41619_()) {
                    ((FluidFilterSlot)slot).onContainerClicked(player.f_36096_.m_142621_());
                }
            } else if (player.f_36096_.m_142621_().m_41619_()) {
                ((FluidFilterSlot)slot).onContainerClicked(ItemStack.f_41583_);
            } else {
                ((FluidFilterSlot)slot).onContainerClicked(player.f_36096_.m_142621_());
            }
            return;
        }
        if (slot instanceof LegacyFilterSlot) {
            if (player.f_36096_.m_142621_().m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else if (slot.m_5857_(player.f_36096_.m_142621_())) {
                slot.m_5852_(player.f_36096_.m_142621_().m_41777_());
            }
            return;
        }
        if (slot instanceof LegacyDisabledSlot) {
            return;
        }
        super.m_150399_(id, dragType, clickType, player);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        return this.transferManager.transfer(slotIndex);
    }

    public boolean m_6875_(Player player) {
        return this.isBlockEntityStillPresent();
    }

    private boolean isBlockEntityStillPresent() {
        if (this.blockEntity != null) {
            return this.blockEntity.m_58904_().m_7702_(this.blockEntity.m_58899_()) == this.blockEntity;
        }
        return true;
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        if (slot instanceof FilterSlot || slot instanceof FluidFilterSlot || slot instanceof LegacyFilterSlot) {
            return false;
        }
        return super.m_5882_(stack, slot);
    }

    protected int getDisabledSlotNumber() {
        return -1;
    }

    protected Slot m_38897_(Slot slot) {
        if (slot instanceof FluidFilterSlot) {
            this.fluids.add(FluidStack.EMPTY);
            this.fluidSlots.add((FluidFilterSlot)slot);
        }
        return super.m_38897_(slot);
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.listener != null && this.isBlockEntityStillPresent()) {
            this.listener.detectAndSendChanges();
        }
        if (this.getPlayer() instanceof ServerPlayer) {
            for (int i = 0; i < this.fluidSlots.size(); ++i) {
                FluidFilterSlot slot = this.fluidSlots.get(i);
                FluidStack cached = this.fluids.get(i);
                FluidStack actual = slot.getFluidInventory().getFluid(slot.getSlotIndex());
                if (API.instance().getComparer().isEqual(cached, actual, 3)) continue;
                this.fluids.set(i, actual.copy());
                RS.NETWORK_HANDLER.sendTo((ServerPlayer)this.getPlayer(), new FluidFilterSlotUpdateMessage(((Slot)slot).f_40219_, actual));
            }
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this.listener != null) {
            this.listener.onClosed();
        }
    }
}

