/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.util;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.Map;

public record VertexFormatOutput(VertexFormat format, String[] varyings, int vertexSize) {
    private static final Map<VertexFormatElement, String> elementVaryingNames;
    private static final Object2ObjectOpenHashMap<VertexFormat, VertexFormatOutput> outputs;

    private VertexFormatOutput(VertexFormat format) {
        this(format, VertexFormatOutput.generateVaryings(format), format.m_86020_());
    }

    public static VertexFormatOutput of(VertexFormat format) {
        return (VertexFormatOutput)outputs.computeIfAbsent((Object)format, e -> new VertexFormatOutput((VertexFormat)e));
    }

    private static int offsetOf(VertexFormat format, VertexFormatElement element) {
        int elementIndex = format.m_86023_().indexOf((Object)element);
        if (elementIndex == -1) {
            return 0;
        }
        return format.getOffset(elementIndex);
    }

    private static String[] generateVaryings(VertexFormat format) {
        ImmutableList elements = format.m_86023_();
        ObjectArrayList list = new ObjectArrayList();
        for (VertexFormatElement element : elements) {
            if (element == DefaultVertexFormat.f_85810_) continue;
            String elementName = elementVaryingNames.get(element);
            if (elementName == null) {
                throw new IllegalStateException("Unknown vertex format element");
            }
            list.add((Object)elementName);
        }
        return (String[])list.toArray((Object[])new String[0]);
    }

    public static String outputName(VertexFormatElement element) {
        return elementVaryingNames.get(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof VertexFormatOutput)) return false;
        VertexFormatOutput other = (VertexFormatOutput)obj;
        if (this.format != other.format) return false;
        return true;
    }

    static {
        outputs = new Object2ObjectOpenHashMap();
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        map.put((Object)DefaultVertexFormat.f_85804_, (Object)"positionOutput");
        map.put((Object)DefaultVertexFormat.f_85809_, (Object)"normalOutput");
        map.put((Object)DefaultVertexFormat.f_85805_, (Object)"colorOutput");
        map.put((Object)DefaultVertexFormat.f_85806_, (Object)"textureOutput");
        map.put((Object)DefaultVertexFormat.f_85807_, (Object)"overlayOutput");
        map.put((Object)DefaultVertexFormat.f_85808_, (Object)"lightmapOutput");
        elementVaryingNames = Collections.unmodifiableMap(map);
    }
}

