/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz.internal.gl46.batching;

import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nullable;
import net.roguelogix.quartz.AABB;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.DynamicMatrix;
import net.roguelogix.quartz.internal.QuartzCore;
import net.roguelogix.quartz.internal.common.DynamicMatrixManager;
import net.roguelogix.quartz.internal.gl46.GL46Core;
import net.roguelogix.quartz.internal.gl46.batching.GL46InstanceManager;
import net.roguelogix.quartz.internal.util.PointerWrapper;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.lwjgl.opengl.GL11C;

@Nullable
public class GL46Instance
implements DrawBatch.Instance {
    final Location location;
    public final WeakReference<GL46Instance> selfWeakRef = new WeakReference<GL46Instance>(this);
    private final GL46InstanceManager manager;
    private final Vector3i position = new Vector3i();
    private DynamicMatrixManager.Matrix dynamicMatrix;
    private final Matrix4f staticMatrix = new Matrix4f();
    private final Matrix4f normalMatrix = new Matrix4f();
    @Nullable
    AABB aabb;
    private int dirtyForFrames;

    GL46Instance(GL46InstanceManager manager, int initialLocation) {
        Location location = new Location(initialLocation);
        QuartzCore.mainThreadClean(this, () -> manager.removeInstance(location));
        this.location = location;
        this.manager = manager;
    }

    void setDirty() {
        if (this.location.location == -1) {
            throw new IllegalStateException("Attempt to dirty deleted instance");
        }
        if (this.dirtyForFrames == 3) {
            return;
        }
        this.manager.dirtyInstances.add(this.selfWeakRef);
        this.manager.setDirty();
        this.dirtyForFrames = 3;
    }

    @Override
    public void updatePosition(Vector3ic position) {
        if (this.position.equals((Object)position)) {
            return;
        }
        this.position.set(position);
        this.setDirty();
    }

    @Override
    public void updateDynamicMatrix(@Nullable DynamicMatrix newDynamicMatrix) {
        DynamicMatrixManager.Matrix dynamicMatrix;
        if (newDynamicMatrix == null) {
            newDynamicMatrix = this.manager.drawBatch.IDENTITY_DYNAMIC_MATRIX;
        }
        if (Objects.equals(this.dynamicMatrix, newDynamicMatrix)) {
            return;
        }
        if (newDynamicMatrix instanceof DynamicMatrixManager.Matrix && this.manager.drawBatch.dynamicMatrixManager.owns(dynamicMatrix = (DynamicMatrixManager.Matrix)newDynamicMatrix)) {
            this.dynamicMatrix = dynamicMatrix;
            this.setDirty();
        }
    }

    @Override
    public void updateStaticMatrix(@Nullable Matrix4fc newStaticMatrix) {
        if (Objects.equals(this.staticMatrix, newStaticMatrix)) {
            return;
        }
        if (newStaticMatrix == null) {
            this.staticMatrix.identity();
            return;
        }
        this.staticMatrix.set(newStaticMatrix);
        this.staticMatrix.normal(this.normalMatrix);
        this.setDirty();
    }

    @Override
    public void updateAABB(@Nullable AABB aabb) {
        if (this.aabb == null && aabb == null) {
            return;
        }
        if (this.aabb == null) {
            this.aabb = aabb;
            this.manager.drawBatch.instanceAABBsDirty();
        }
        if (this.aabb.minX() >> 4 != aabb.minX() >> 4 || this.aabb.minY() >> 4 != aabb.minY() >> 4 || this.aabb.minZ() >> 4 != aabb.minZ() >> 4 || this.aabb.maxX() >> 4 != aabb.maxX() >> 4 || this.aabb.maxY() >> 4 != aabb.maxY() >> 4 || this.aabb.maxZ() >> 4 != aabb.maxZ() >> 4) {
            this.manager.drawBatch.instanceAABBsDirty();
        }
        this.aabb = aabb;
    }

    @Override
    public void delete() {
        this.manager.removeInstance(this.location);
    }

    boolean write() {
        if (!this.dirty()) {
            return false;
        }
        PointerWrapper instanceGPUMemory = this.manager.instanceDataAlloc.activeAllocation().address().slice((long)this.location.location * 128L, 128L);
        instanceGPUMemory.putMatrix4f(0L, (Matrix4fc)this.staticMatrix);
        instanceGPUMemory.putMatrix3x4f(64L, (Matrix4fc)this.normalMatrix);
        instanceGPUMemory.putVector3i(112L, (Vector3ic)this.position);
        instanceGPUMemory.putInt(124L, this.dynamicMatrix.id(GL46Core.INSTANCE.frameInFlight()));
        --this.dirtyForFrames;
        return this.dirty();
    }

    boolean dirty() {
        return this.dirtyForFrames > 0;
    }

    void printAllInstanceData() {
        GL11C.glFinish();
        for (int i = 0; i < 4; ++i) {
            PointerWrapper instanceGPUMemory = this.manager.instanceDataAlloc.allocation(i).address().slice((long)this.location.location * 128L, 128L);
            Matrix4f mat = new Matrix4f();
            instanceGPUMemory.getMatrix4f(0L, mat);
            System.out.println(mat);
            instanceGPUMemory.getMatrix3x4f(64L, mat);
            System.out.println(mat);
            Vector3i vec = new Vector3i();
            instanceGPUMemory.getVector3i(112L, vec);
            System.out.println(vec);
            System.out.println(instanceGPUMemory.getInt(124L));
        }
        System.out.println();
    }

    static class Location {
        int location;

        private Location(int location) {
            this.location = location;
        }
    }
}

