/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.quartz;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.roguelogix.phosphophyllite.registry.Registry;
import net.roguelogix.phosphophyllite.util.NonnullDefault;
import net.roguelogix.quartz.AABB;
import net.roguelogix.quartz.DrawBatch;
import net.roguelogix.quartz.Mesh;
import net.roguelogix.quartz.internal.QuartzCore;
import org.joml.Vector3ic;

@Mod(value="quartz")
@NonnullDefault
public final class Quartz {
    public static final String modid = "quartz";
    public static IEventBus EVENT_BUS = BusBuilder.builder().setTrackPhases(false).build();

    public Quartz() {
        new Registry((List)ReferenceArrayList.of((Object[])new ResourceLocation[]{new ResourceLocation("phosphophyllite", "creative_tab")}), (List)new ReferenceArrayList());
    }

    public static Mesh createStaticMesh(BlockState blockState) {
        return Quartz.createStaticMesh((Mesh.Builder builder) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            BlockColors blockColors = minecraft.m_91298_();
            BlockRenderDispatcher renderer = minecraft.m_91289_();
            ModelBlockRenderer modelRenderer = renderer.m_110937_();
            BakedModel blockModel = renderer.m_110910_(blockState);
            ChunkRenderTypeSet renderTypes = blockModel.getRenderTypes(blockState, RandomSource.m_216335_((long)42L), ModelData.EMPTY);
            int color = blockColors.m_92577_(blockState, null, null, 0);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            PoseStack.Pose topOfStack = builder.matrixStack().m_85850_();
            MultiBufferSource bufferSource = builder.bufferSource();
            for (RenderType rt : renderTypes) {
                modelRenderer.renderModel(topOfStack, bufferSource.m_6299_(rt), blockState, blockModel, r, g, b, 0, 0, ModelData.EMPTY, rt);
            }
        });
    }

    public static Mesh createStaticMesh(ResourceLocation modelLocation) {
        QuartzCore.registerModel(modelLocation);
        return Quartz.createStaticMesh((Mesh.Builder builder) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            BlockRenderDispatcher renderer = minecraft.m_91289_();
            ModelBlockRenderer modelRenderer = renderer.m_110937_();
            BakedModel model = minecraft.m_91304_().getModel(modelLocation);
            ChunkRenderTypeSet renderTypes = model.getRenderTypes(Blocks.f_50069_.m_49966_(), RandomSource.m_216335_((long)42L), ModelData.EMPTY);
            PoseStack.Pose topOfStack = builder.matrixStack().m_85850_();
            MultiBufferSource bufferSource = builder.bufferSource();
            for (RenderType rt : renderTypes) {
                modelRenderer.renderModel(topOfStack, bufferSource.m_6299_(rt), null, model, 1.0f, 1.0f, 1.0f, 0, 0, ModelData.EMPTY, rt);
            }
        });
    }

    public static Mesh createStaticMesh(Consumer<Mesh.Builder> buildFunc) {
        return QuartzCore.INSTANCE.meshManager.createMesh(buildFunc);
    }

    public static DrawBatch getDrawBatchForBlock(BlockPos blockPos) {
        return Quartz.getDrawBatcherForSection(SectionPos.m_175568_((BlockPos)blockPos));
    }

    public static DrawBatch getDrawBatcherForBlock(Vector3ic blockPos) {
        return Quartz.getDrawBatcherForSection(SectionPos.m_123209_((int)(blockPos.x() >> 4), (int)(blockPos.y() >> 4), (int)(blockPos.z() >> 4)));
    }

    public static DrawBatch getDrawBatcherForSection(long sectionPos) {
        return QuartzCore.INSTANCE.getWorldEngine().getBatcherForSection(sectionPos);
    }

    public static DrawBatch getDrawBatcherForAABB(AABB aabb) {
        return QuartzCore.INSTANCE.getWorldEngine().getBatcherForAABB(aabb);
    }

    public static DrawBatch getEntityBatcher() {
        return QuartzCore.INSTANCE.getEntityBatcher();
    }
}

