/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TreePollinationRecipe
implements Recipe<Container> {
    public final ResourceLocation id;
    public final Ingredient leafA;
    public final Ingredient leafB;
    public final ItemStack result;
    public final Integer chance;

    public TreePollinationRecipe(ResourceLocation id, Ingredient leafA, Ingredient leafB, ItemStack result, Integer chance) {
        this.id = id;
        this.leafA = leafA;
        this.leafB = leafB;
        this.result = result;
        this.chance = chance;
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public boolean matches(BlockState leafAState, BlockState leafBState) {
        return this.leafA.test(new ItemStack((ItemLike)leafAState.m_60734_().m_5456_())) && this.leafB.test(new ItemStack((ItemLike)leafBState.m_60734_().m_5456_()));
    }

    public ItemStack m_5874_(Container container, RegistryAccess level) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess level) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TreeRegistrator.TREE_POLLINATION.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TreeRegistrator.TREE_POLLINATION_TYPE.get();
    }

    public static class Serializer<T extends TreePollinationRecipe>
    implements RecipeSerializer<T> {
        final IRecipeFactory<T> factory;

        public Serializer(IRecipeFactory<T> factory) {
            this.factory = factory;
        }

        @Nonnull
        public T fromJson(ResourceLocation id, JsonObject json) {
            Ingredient inputA = GsonHelper.m_13885_((JsonObject)json, (String)"leafA") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"leafA")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"leafA"));
            Ingredient inputB = GsonHelper.m_13885_((JsonObject)json, (String)"leafB") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"leafB")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"leafB"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int chance = GsonHelper.m_13824_((JsonObject)json, (String)"chance", (int)100);
            return this.factory.create(id, inputA, inputB, output, chance);
        }

        public T fromNetwork(@Nonnull ResourceLocation id, @Nonnull FriendlyByteBuf buffer) {
            return this.factory.create(id, Ingredient.m_43940_((FriendlyByteBuf)buffer), Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130267_(), buffer.readInt());
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, T recipe) {
            ((TreePollinationRecipe)recipe).leafA.m_43923_(buffer);
            ((TreePollinationRecipe)recipe).leafB.m_43923_(buffer);
            buffer.m_130055_(((TreePollinationRecipe)recipe).result);
            buffer.writeInt(((TreePollinationRecipe)recipe).chance.intValue());
        }

        public static interface IRecipeFactory<T extends TreePollinationRecipe> {
            public T create(ResourceLocation var1, Ingredient var2, Ingredient var3, ItemStack var4, Integer var5);
        }
    }
}

