/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.event;

import cy.jdkdigital.productivelib.event.BeeReleaseEvent;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.common.block.ProductiveLogBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveSaplingBlock;
import cy.jdkdigital.productivetrees.common.block.entity.PollinatedLeavesBlockEntity;
import cy.jdkdigital.productivetrees.integrations.productivebees.CompatHandler;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="productivetrees")
public class EventHandler {
    @SubscribeEvent
    public static void onServerStarting(AddReloadListenerEvent event) {
        TreeFinder.context = event.getConditionContext();
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> TreeFinder.trees.forEach((id, treeObject) -> {
            ComposterBlock.f_51914_.put((Object)TreeUtil.getBlock(id, "_sapling"), 0.3f);
            ComposterBlock.f_51914_.put((Object)TreeUtil.getBlock(id, "_leaves"), 0.3f);
            if (treeObject.hasFruit()) {
                ComposterBlock.f_51914_.put((Object)treeObject.getFruit().getItem().m_41720_(), 0.65f);
            }
        }));
    }

    @SubscribeEvent
    public static void blockBreak(BlockEvent.BreakEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            if (event.getState().m_60713_((Block)TreeRegistrator.POLLINATED_LEAVES.get()) && (levelAccessor = level.m_7702_(event.getPos())) instanceof PollinatedLeavesBlockEntity) {
                PollinatedLeavesBlockEntity pollinatedLeavesBlockEntity = (PollinatedLeavesBlockEntity)levelAccessor;
                Block.m_49840_((Level)level, (BlockPos)event.getPos(), (ItemStack)pollinatedLeavesBlockEntity.getResult().m_41777_());
            }
        }
    }

    @SubscribeEvent
    public static void blockToolModified(BlockEvent.BlockToolModificationEvent event) {
        LevelAccessor levelAccessor;
        if (!event.isSimulated() && event.getToolAction().equals(ToolActions.AXE_STRIP) && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
            ProductiveLogBlock logBlock;
            TreeObject tree;
            ServerLevel level = (ServerLevel)levelAccessor;
            Block block = event.getLevel().m_8055_(event.getPos()).m_60734_();
            if (block instanceof ProductiveLogBlock && (tree = TreeUtil.getTree((Block)(logBlock = (ProductiveLogBlock)block))) != null && !tree.getStripDrop().get().m_41619_()) {
                Block.m_49840_((Level)level, (BlockPos)event.getPos(), (ItemStack)tree.getStripDrop().get().m_41777_());
            }
        }
    }

    @SubscribeEvent
    public static void beeRelease(BeeReleaseEvent event) {
        if (ModList.get().isLoaded("productivebees")) {
            CompatHandler.beeRelease(event);
        }
    }

    @SubscribeEvent
    public static void onBlockGrow(SaplingGrowTreeEvent event) {
        ProductiveSaplingBlock saplingBlock;
        ServerLevel serverLevel;
        Block grownBlock;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (grownBlock = (serverLevel = (ServerLevel)levelAccessor).m_8055_(event.getPos()).m_60734_()) instanceof ProductiveSaplingBlock && !(saplingBlock = (ProductiveSaplingBlock)grownBlock).getTree().getMutationInfo().target().equals((Object)ProductiveTrees.EMPTY_RL) && saplingBlock.getTree().getMutationInfo().chance() >= event.getRandomSource().m_188501_()) {
            event.setFeature(ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)saplingBlock.getTree().getMutationInfo().target()));
        }
    }
}

